% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcTNZPDF.R
\name{calcTNZPDF}
\alias{calcTNZPDF}
\alias{clacTNZ}
\alias{tnzpdf}
\alias{TNZPDF}
\alias{TPDF}
\alias{tpdf}
\title{Values related to TNZ approach}
\usage{
calcTNZPDF(ht, wt, age, gender, clo, vel, tskObs, taObs, met, rh,
fBasMet = "rosa", fSA = "duBois", percCov = 0, TcMin = 36, TcMax = 38,
plotZone = FALSE, gridTaMin = 20, gridTaMax = 30, gridTskMin = 30, gridTskMax = 42,
gridTa = 1000, gridTsk = 1000, sa = 1.86, IbMax = 0.124, IbMin = 0.03, alphaIn = 0.08,
metMin = 55.3, metMax = 57.3, metDiff = .1, forPDF = FALSE, metAdapt = "none", 
trm = 15, TcPreAdapt = 37.2)
}
\arguments{
\item{ht}{a numeric value presenting body height in [cm].}

\item{wt}{a numeric value presenting body weight in [kg].}

\item{age}{a numeric value presenting the age in [years].}

\item{gender}{a numeric value presenting sex (female = 1, male = 2)}

\item{clo}{a numeric value presenting clothing insulation level in [clo].}

\item{vel}{a numeric value presenting air velocity in [m/s].}

\item{tskObs}{a numeric value presenting actual mean skin temperature in [degree C].}

\item{taObs}{a numeric value presenting actual air temperature in [degree C].}

\item{met}{a numeric value presenting metabolic rate (activity related) in [met].}

\item{rh}{a numeric value presenting realtive humidity in [\%].}

\item{fBasMet}{a string presenting the method of calculating basal metbolic rate. 
Needs to be one of "rosa", "harris", "miflin", "fixed", or "direct". 
Fixed will result in the value of 58.2 W/m2. Direct requires definition of metMin and metMax.}

\item{fSA}{a string presenting the method of calculating the surface area. Needs to be one of "duBois", "mosteller", or "direct".}

\item{percCov}{a numeric value between 0 and 1 presenting the percentage of the body covered by clothes in [\%].}

\item{TcMin}{a numeric value presenting the minimum allowed core temperature in [degree C].}

\item{TcMax}{a numeric value presenting the maximum allowed core temperature in [degree C].}

\item{plotZone}{a boolean variable TRUE or FALSE stating, wether TNZ should be plotted or not.}

\item{gridTaMin}{a numeric value defining the minimum grid value for Ta, ambient temperature, in [degree C].}

\item{gridTaMax}{a numeric value defining the maximum grid value for Ta, ambient temperature, in [degree C].}

\item{gridTskMin}{a numeric value defining the minimum grid value for Tsk, skin temperature, in [degree C].}

\item{gridTskMax}{a numeric value defining the maximum grid value for Tsk, skin temperature, in [degree C].}

\item{gridTa}{a numeric value defining the grid size in Ta dimension.}

\item{gridTsk}{a numeric value defining the grid size in Tsk dimension.}

\item{sa}{a numeric value for surface area (only used with method fSA: direct) in [m2].}

\item{IbMax}{a numeric value for maximum body tissue insulation in [m2K/W].}

\item{IbMin}{a numeric value for minimum body tissue insulation in [m2K/W].}

\item{alphaIn}{a numeric value for alpha (if 0, alpha will be calculated according to Fanger.}

\item{metMin}{a numeric value for minimum metabolic rate (only used with method fBasMet:direct) in [W/m2].}

\item{metMax}{a numeric value for maximum metabolic rate (only used with method fBasMet:direct) in [W/m2].}

\item{metDiff}{a numeric value for difference between minimum and maximum metabolic rate (not used with method fBasMet:direct) in [W/m2].}

\item{forPDF}{a boolean value. If TRUE, matrix for drawing of PDF will be output, if FALSE, values for dTNZ and others will be output.}

\item{metAdapt}{a string presenting the method of calculating the surface area. Needs to be one of 'Hori', 'Q10', 'ATHB', or 'none'. NOTE: all methods applied here still in development and need further validation.}

\item{trm}{numerical value presenting the running mean outdoor temperature in [degree C]. Only used with metAdapt: Hori and ATHB.}

\item{TcPreAdapt}{numerical value presenting the initial core temperature before adaptation in [degree C]. Only used with metAdapt: Q10.}
}
\value{
\code{calcTNZPDF} returns either a dataframe suitbale to draw the pdf of TNZ (by setting forPDF to TURE) or a dataframe with the columns dTNZ, dTNZTs, dTNZTa and others.  Thereby
\item{dTNZ }{The absolute distance to the centroid of the thermoneutral zone}
\item{dTNZTs }{Relative value of distance assuming skin temperature to be dominant for sensation}
\item{dTNZTa }{Relative value of distance assuming ambient temperature to be dominant for sensation}
}
\description{
\code{calcTNZPDF} calculates the distance from the thermoneutral zone, either skin temperature or room air related. Also calculates the probability function (PDF) of the thermoneutral zone.
}
\details{
The percentage of the body covered by clothes can be estimated e.g. based on ISO 9920 Appendix H (Figure H.1).  A typical winter case leads to a value of around .86, in the summer case this goes down to values around .68.
}
\note{
This function was used for the review paper by Schweiker et al. (2018) (see reference above). Some of the equations implemented are still to be validated further - therefore, use this function and its parameters with great care.

This function is not (yet) implemented in \code{calcComfInd}, \code{calcdTNZ} is applied there.
}
\examples{
## Calculate and draw pdf of TNZ for a young non-obese male
longTcYoungMale <- calcTNZPDF(ht = 178, wt = 70, age = 30, gender = 2, clo = 0.5,
           vel = 0.2, tskObs = 36.2, taObs = 26, met = 1,
           rh = 50, fBasMet = "rosa", fSA = "duBois", percCov = 0.6,
           TcMin = 36, TcMax = 38, plotZone = FALSE, gridTaMin = 20, gridTaMax = 30,
           gridTskMin = 20, gridTskMax = 42, gridTa = 1000, gridTsk = 1000, 
           sa = 2.0335, IbMax = 0.124, IbMin = 0.03, alphaIn = 0, metMin = 55.3, 
           metMax = 57.3, metDiff = 0.1, forPDF = TRUE)

plot(density(longTcYoungMale$X2), main="", xlim=c(14,36), ylim=c(0,.50),
    xlab="Operative temperature [degree C]")
}
\references{
Schweiker, Huebner, Kingma, Kramer & Pallubinsky (2018) <doi:10.1080/23328940.2018.1534490>
Kingma, Schweiker, Wagner & van Marken Lichtenbelt 
Exploring the potential of a biophysical model to understand thermal sensation 
Proceedings of 9th Windsor Conference: Making Comfort Relevant Cumberland 
Lodge, Windsor, UK, 2016.
Kingma & van Marken Lichtenbelt (2015) <doi:10.1038/nclimate2741>
Kingma, Frijns, Schellen & van Marken Lichtenbelt (2014) <doi:10.4161/temp.29702>
}
\seealso{
\code{\link{calcdTNZ}}
}
\author{
Marcel Schweiker and Boris Kingma
}
