% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcAvgAcc.R
\name{calcAvgAcc}
\alias{calcAvgAcc}
\alias{calcavgacc}
\alias{AvgAcc}
\alias{avgacc}
\title{Average Accuracy between Predicted and Actual Thermal Sensation Vote}
\usage{
calcAvgAcc(ref, pred)

calcavgacc(ref, pred)

AvgAcc(ref, pred)

avgacc(ref, pred)
}
\arguments{
\item{ref}{a numeric item or vector containing categorical actual thermal sensation votes coded from -3 'cold' to +3 'hot'}

\item{pred}{a numeric item or vector containing categorical predicted thermal sensation votes coded from -3 'cold' to +3 'hot'}
}
\value{
\code{calcAvgAcc} returns a single value presenting the average accuracy between actual and predicted thermal sensation votes.
}
\description{
\code{calcAvgAcc} calculates the average accuracy between predicted thermal sensation votes and actual obtained sensation votes
}
\note{
The outcome heavily depends on the distribution of actual votes, i.e. in case most of the actual votes are in the same category, e.g. 'neutral', the average accuray is very high due to the fact that for the other categories the number of TRUE negative predicted votes is high as well.
}
\examples{
## Define data
ref <- rnorm(5) # actual thermal sensation votes
ref <- cutTSV(ref)

pred <- rnorm(5) # predicted thermal sensation votes
pred <- cutTSV(pred)

calcAvgAcc(ref, pred)
}
\references{
Sokolova and Lapalme (2009) <doi:10.1016/j.ipm.2009.03.002>
}
\seealso{
\code{\link{calcTPRTSV}}, \code{\link{calcMeanBias}}
}
\author{
Marcel Schweiker. Further contribution by Shoaib Sarwar.
}
