% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_raw_image_handling.R
\name{plotPixels}
\alias{plotPixels}
\title{Plot pixels in color space}
\usage{
plotPixels(img, n = 10000, lower = c(0, 0.55, 0), upper = c(0.25, 1,
  0.25), color.space = "rgb", ref.white = NULL, pch = 20,
  main = "default", from = "sRGB", xlim = "default", ylim = "default",
  zlim = "default", ...)
}
\arguments{
\item{img}{Either a path to an image or a \code{\link{loadImage}} object.}

\item{n}{Number of randomly selected pixels to plot; recommend <20000 for
speed. If n exceeds the number of non-background pixels in the image, all
pixels are plotted. If n is not numeric, all pixels are plotted.}

\item{lower}{RGB or HSV triplet specifying the lower bounds for background
pixels. Default upper and lower bounds are set to values that work well for
a bright green background (RGB [0, 1, 0]).}

\item{upper}{RGB or HSV triplet specifying the upper bounds for background
pixels. Default upper and lower bounds are set to values that work well for
a bright green background (RGB [0, 1, 0]). Determining these bounds may
take some trial and error, but the following bounds may work for certain
common background colors: \itemize{ \item Black: lower=c(0, 0, 0);
upper=c(0.1, 0.1, 0.1) \item White: lower=c(0.8, 0.8, 0.8); upper=c(1, 1,
1) \item Green: lower=c(0, 0.55, 0); upper=c(0.24, 1, 0.24) \item Blue:
lower=c(0, 0, 0.55); upper=c(0.24, 0.24, 1) } If no background filtering is
needed, set bounds to some non-numeric value (\code{NULL}, \code{FALSE},
\code{"off"}, etc); any non-numeric value is interpreted as \code{NULL}.}

\item{color.space}{The color space (\code{"rgb"}, \code{"hsv"}, or
\code{"lab"}) to use for plotting.}

\item{ref.white}{The reference white passed to
\code{\link[grDevices]{convertColor}}; must be specified if \code{img} does
not already contain CIE Lab pixels. See \link{convertColorSpace}.}

\item{pch}{Passed to \code{\link[scatterplot3d]{scatterplot3d}}.}

\item{main}{Plot title. If left as "default", image name is used.}

\item{from}{Original color space of image if plotting in CIE Lab space,
probably either "sRGB" or "Apple RGB", depending on your computer.}

\item{xlim, ylim, zlim}{Ranges for the X, Y, and Z axes. If "default", the
widest ranges for each axis according to the specified color space (0-1 for
RGB and HSV, 0-100 for L of Lab, -128-127 for a and b of Lab) are used.}

\item{...}{Optional parameters passed to
\code{\link[scatterplot3d]{scatterplot3d}}.}
}
\value{
3D plot of pixels in either RGB or HSV color space, colored according
  to their color in the image. Uses
  \code{\link[scatterplot3d]{scatterplot3d}} function.
}
\description{
Plots non-background pixels according to their color coordinates, and colors
them according to their RGB or HSV values. Dimensions are either RGB or HSV
depending on flags.
}
\note{
If \code{n} is not numeric, then all pixels are plotted, but this is
  not recommended. Unless the image has a low pixel count, it takes much
  longer, and plotting this many points in the plot window can obscure
  important details.
  
  There are seven CIE standardized illuminants available in
  \code{colordistance} (A, B, C, E, and D50, D55, and D65), but the most
  common are: \itemize{ \item \code{"A"}: Standard incandescent lightbulb
  \item \code{"D65"}: Average daylight \item \code{"D50"}: Direct sunlight}
}
\examples{
colordistance::plotPixels(system.file("extdata",
"Heliconius/Heliconius_B/Heliconius_07.jpeg", package="colordistance"),
n=20000, upper=rep(1, 3), lower=rep(0.8, 3), color.space = "rgb", angle = -45)
}
