% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{df_style<-}
\alias{df_style<-}
\alias{df_style}
\title{Get or set style of a colorful data frame}
\usage{
df_style(x, element = NULL) <- value

df_style(x, element)
}
\arguments{
\item{x}{a colorful data frame}

\item{element}{element or elements of the style}

\item{value}{one or more values to set}
}
\value{
\code{df_style(x)} returns a list. Assignment results in a data frame
with a modified style.
}
\description{
Get or set style of a colorful data frame
}
\details{
Colorful data frames store the styles in the \code{.style} attribute of the
data frame object. This attribute is a list with a number of keywords:
\itemize{
\item fg, bg, decoration: formatting styles to be applied to the whole table
(see "Formatting styles" below)
\item row.names, col.names, interleave: formatting styles for row names, table header and
every second line in the table. If these elements are NULL, no styles
will be applied. See "Formatting styles" below.
\item autoformat (logical): whether column type should be guessed from column names
(which allows automatically recognizing a column called "pvalue" as a
p-value and color significant cells.
\item col.styles: a list mapping the column names to formatting styles.
\item col.types: a list mapping the column names to column types. For example,
if it is \code{list(result="pval")}, then the column with name "result" will
be considered to be a p-value and styled accordingly.
\item type.styles: a list mapping column types to formatting styles. See "Formatting styles"
below and help page for \code{\link[=col_type]{col_type()}}.
\item fixed.width: if not NULL, all columns have the same width
\item sep: string separating the columns
\item digits: how many digits to use
\item tibble.style: if not NULL, cut off columns that do not fit the width
}
}
\section{Formatting styles}{


Each formatting style is a list describing style of the formatting and
coloring the text elements. Following elements of that list are recognized:
\itemize{
\item fg, bg: foreground and background colors specified as R name (use
\code{colors()} to get available colors) or HTML hexadicimal code
\item fg_sign: for p-values, foreground color for significant
values
\item fg_true, fg_false: foreground colors for logical vectors
\item fg_neg: for numeric values, foreground color for negative values
\item fg_na: color for NA values
\item is.pval: whether the values are to be treated as p-values
\item is.numeric: whether the values are to be treated as numeric
\item align: how the values should be aligned (right, left or center)
\item sign.thr: for p-values, the threshold of significance
\item digits: how many digits to use
\item decoration: a character vector which may include the following key
words: inverse, bold, italic
}
}

\examples{
df <- as.colorDF(mtcars)

## row names should be red on yellow background (yikes!)
df_style(df, "row.names") <- list(fg="red", bg="#FFFF00")

## you can use `$` to access the elements
## here, show significant p-values in green
df_style(df)$type.styles$pval$fg_sign <- "green"

## example of assigning multiple values in one assignment:
df_style(df) <- list(interleave=list(fg="#FFFFFF", bg="blue"),
                  row.names=list(fg="blue", bg="#FFFF00"), 
                  col.names=list(bg="#FFFFFF", fg="#FF00FF", 
                                 decoration=c("bold", "italic")))

}
\seealso{
\code{\link[=print.colorDF]{print.colorDF()}} on printing options; \code{\link[=col_type]{col_type()}} for column
types.
}
