% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.coenocline.R
\name{plot.coenocline}
\alias{lines.coenocline}
\alias{plot.coenocline}
\title{Plot species simulations along gradients}
\usage{
\method{plot}{coenocline}(x, type = "p", pch = 1, ...)

\method{lines}{coenocline}(x, lty = "solid", ...)
}
\arguments{
\item{x}{an object of class \code{"coenocline"}, the result of a call to \code{\link{coenocline}}.}

\item{type}{character; the type of plot to produce. See \code{\link{plot.default}} for details.}

\item{pch}{the plotting character to use. See \code{\link{plot.default}} for details.}

\item{...}{additional arguments to \code{\link{matplot}}.}

\item{lty}{the line type to use. See \code{\link{plot.default}} for details.}
}
\value{
A plot is drawn on the current device.
}
\description{
A simple S3 \code{\link{plot}} method for coenocline simulations.
}
\examples{
## Poisson counts along a single gradient, Gaussian response
## =========================================================

x <- seq(from = 4, to = 6, length = 100)
opt <- c(3.75, 4, 4.55, 5, 5.5) + 0.5
tol <- rep(0.25, 5)
h <- rep(20, 5)

## simulate
set.seed(1)
y <- coenocline(x, responseModel = "gaussian",
                params = cbind(opt = opt, tol = tol, h = h),
                countModel = "poisson")
head(y)

y <- coenocline(x, responseModel = "gaussian",
                params = cbind(opt = opt, tol = tol, h = h),
                countModel = "poisson",
                expectation = TRUE)
plot(y, type = "l", lty = "solid")
}
\author{
Gavin L. Simpson
}
\keyword{hplot}

