% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_tools.R
\name{var_explained}
\alias{var_explained}
\title{Sum-of-squares values showing what portion of variance in dvec is explained
by dvec_est}
\usage{
var_explained(dvec, dvec_est)
}
\arguments{
\item{dvec}{[1,m] numeric, data vector}

\item{dvec_est}{[1,m] numeric, data vector, an estimate of dvec}
}
\value{
A list with elements:
\item{ss_tot:}{Sum of squares in dvec}
\item{ss_est:}{Sum of squares in dvec_est}
\item{ss_err:}{Sum of squares of dvec - dvec_est}
\item{R2:}{Percentage of variance explained i.e. 1 - ss_err/ss_tot}
}
\description{
Computation as in:
http://en.wikipedia.org/wiki/Fraction_of_variance_unexplained

ss_est becomes zero if dvec_est equals dvec_0=rep(mean(dvec),length(dvec)).
If dvec_est is better estimate than dvec_0, R2 is positive.
If dvec_est is worse than dvec_0, R2 is negative.
}
