% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/common_tools.R
\name{variability_components}
\alias{variability_components}
\title{Compute total, within group and between group variability using fun}
\usage{
variability_components(vec, grp, fun)
}
\arguments{
\item{vec}{[1,M] numeric, Data vector}

\item{grp}{[1,M] integer/character vector, Some grouping of vec}

\item{fun}{function, Function to use when quantifying the variability}
}
\value{
A list with elements:
\item{tvar:}{Total variability}
\item{bgvar:}{Between groups variability, tvar - sum(wgvar_*)}
\item{wgvar_<groupname>:}{Within group variability for each group}
\item{wg_rel:}{sum(wgvar)/tvar}
\item{bg_rel:}{bgvar/tvar}
}
\description{
The function used the definition: gvar = tvar - wgvar
}
\examples{
vec <- rnorm(10)
grp <- rep(c("a","b","c"), c(3,3,4))
variability_components(vec, grp, ss)
}

