% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.cocor.input.r
\docType{methods}
\name{get.cocor.input}
\alias{get.cocor.input}
\alias{get.cocor.input,-method}
\alias{get.cocor.input,cocor-method}
\alias{get.cocor.input,cocor.dep.groups.nonoverlap-method}
\alias{get.cocor.input,cocor.dep.groups.overlap-method}
\alias{get.cocor.input,cocor.indep.groups-method}
\title{Get input parameters of a cocor result object}
\usage{
get.cocor.input(result.object)

\S4method{get.cocor.input}{cocor}(result.object)
}
\arguments{
\item{result.object}{A cocor result object of class 'cocor.indep.groups',
      'cocor.dep.groups.overlap', or 'cocor.dep.groups.nonoverlap'.}
}
\value{
Returns a list containing all input parameters as list elements:
\item{r1.jk}{A number specifying the correlation between j and k measured in group 1 (only for result objects of class 'cocor.indep.groups').}
\item{r2.hm}{A number specifying the correlation between h and m measured in group 2 (only for result objects of class 'cocor.indep.groups').}
\item{n1}{An integer defining the size of group 1 (only for result objects of class 'cocor.indep.groups').}
\item{n2}{An integer defining the size of group 2 (only for result objects of class 'cocor.indep.groups').}
\item{r.jk}{A number specifying the correlation between j and k (only for result objects of class 'cocor.dep.groups.overlap' and 'cocor.dep.groups.nonoverlap').}
\item{r.jh}{A number specifying the correlation between j and h (only for result objects of class 'cocor.dep.groups.overlap').}
\item{r.hm}{A number specifying the correlation between h and m (only for result objects of class 'cocor.dep.groups.nonoverlap').}
\item{n}{An integer defining the size of the group (only for result objects of class 'cocor.dep.groups.overlap' and 'cocor.dep.groups.nonoverlap').}
\item{alternative}{A character string specifying whether the alternative hypothesis is two-sided ("two.sided") or one-sided ("greater" or "less",
      depending on the direction).}
\item{alpha}{A number defining the alpha level for the hypothesis test.}
\item{conf.level}{A number defining the level of confidence for the confidence interval.}
\item{null.value}{A number defining the hypothesized difference between the two correlations used for testing the null hypothesis.}
\item{data.name}{A vector of character strings describing the data/groups.}
\item{var.labels}{A vector of four character strings specifying the labels for j, k, h,
      and m (in this order).}
}
\description{
Returns input parameters of a cocor result object of class 'cocor.indep.groups',
      'cocor.dep.groups.overlap',
      or 'cocor.dep.groups.nonoverlap' as a list with each slot representing a list element.
}
\examples{
data("aptitude")

cocor.result <- cocor(~knowledge + intelligence.a | logic + intelligence.a,
      aptitude$sample1)
get.cocor.input(cocor.result)

}
\seealso{
\link{get.cocor.results}, \link{cocor}, \link{cocor.indep.groups},
      \link{cocor.dep.groups.overlap}, \link{cocor.dep.groups.nonoverlap}
}

