% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_stats.R
\name{format_stats.htest}
\alias{format_stats.htest}
\title{Format hypothesis test statistics}
\usage{
\method{format_stats}{htest}(
  x,
  digits = NULL,
  pdigits = 3,
  pzero = FALSE,
  full = TRUE,
  italics = TRUE,
  dfs = "par",
  mean = "abbr",
  type = "md",
  ...
)
}
\arguments{
\item{x}{An \code{htest} object}

\item{digits}{Number of digits after the decimal for means, confidence
intervals, and test statistics}

\item{pdigits}{Number of digits after the decimal for p-values, ranging
between 1-5 (also controls cutoff for small p-values)}

\item{pzero}{Logical value (default = FALSE) for whether to include
leading zero for p-values}

\item{full}{Logical value (default = TRUE) for whether to include means
and confidence intervals or just test statistic and p-value}

\item{italics}{Logical value (default = TRUE) for whether \emph{p} label should be
italicized}

\item{dfs}{Formatting for degrees of freedom ("par" = parenthetical,
"sub" = subscript, "none" = do not print degrees of freedom)}

\item{mean}{Formatting for mean label ("abbr" = M, "word" = Mean)}

\item{type}{Type of formatting ("md" = markdown, "latex" = LaTeX)}

\item{...}{Additional arguments passed to methods.}
}
\value{
A character string of statistical information formatted in Markdown or LaTeX.
}
\description{
This method formats hypothesis test statistics from the class \code{htest}.
Currently, this includes correlations from \code{\link[=cor.test]{cor.test()}} and t-tests and
Wilcoxon tests from \code{\link[=t.test]{t.test()}} and \code{\link[=wilcox.test]{wilcox.test()}}. For correlations, the
function detects whether the object is from a Pearson,
Spearman, or Kendall correlation and reports the appropriate correlation
label (r, \eqn{\tau}, \eqn{\rho}). The default output is APA formatted, but
this function allows control over numbers of
digits, leading zeros, the presence of means and confidence intervals,
italics, degrees of freedom, and mean labels, and output format of
Markdown or LaTeX.
}
\examples{
# Prepare statistical objects
test_corr <- cor.test(mtcars$mpg, mtcars$cyl)
test_corr2 <- cor.test(mtcars$mpg, mtcars$cyl, method = "kendall")
test_ttest <- t.test(mtcars$vs, mtcars$am)
test_ttest2 <- wilcox.test(mtcars$vs, mtcars$am)

# Format correlation
format_stats(test_corr)

# Remove confidence intervals and italics
format_stats(test_corr, full = FALSE, italics = FALSE)

# Change digits and add leading zero to p-value
format_stats(test_corr, digits = 3, pdigits = 4, pzero = TRUE)

# Format Kendall's tau
format_stats(test_corr2)

# Format t-test
  format_stats(test_ttest)

# Remove mean and confidence interval
format_stats(test_ttest, full = FALSE)

# Remove degrees of freedom and spell out "Mean"
format_stats(test_ttest, dfs = "none", mean = "word")

# Format for LaTeX
format_stats(test_ttest2, type = "latex")
}
\seealso{
Other functions for printing statistical objects: 
\code{\link{format_bf}()},
\code{\link{format_corr}()},
\code{\link{format_stats}()},
\code{\link{format_stats.BFBayesFactor}()},
\code{\link{format_stats.easycorrelation}()},
\code{\link{format_ttest}()}
}
\concept{functions for printing statistical objects}
