\name{bal.tab.ps}
\alias{bal.tab.ps}
\alias{bal.tab.mnps}
\alias{bal.tab.iptw}
\alias{bal.tab.ps.cont}
\title{
Balance Statistics for \code{twang} Objects
}
\description{
Generates balance statistics for \code{ps}, \code{mnps}, and \code{iptw} objects from \pkg{twang} and for \code{ps.cont} objects from \pkg{twangContinuous}.
}
\usage{
\method{bal.tab}{ps}(x, 
        stop.method,
        stats,
        int = FALSE,
        poly = 1,
        distance = NULL,
        addl = NULL,
        data = NULL,
        continuous,
        binary,
        s.d.denom,
        thresholds = NULL,
        weights = NULL,
        cluster = NULL,
        imp = NULL,
        pairwise = TRUE,
        s.weights = NULL,
        abs = FALSE,
        subset = NULL,
        quick = TRUE,
        ...)
}

\arguments{
  \item{x}{
a \code{ps}, \code{mnps}, \code{iptw}, or \code{ps.cont} object; the output of a call to \pkgfun{twang}{ps}, \pkgfun{twang}{mnps}, \pkgfun{twang}{iptw} or \pkgfun{twangContinuous}{ps.cont}.
}
  \item{stop.method}{
a string containing the names of the stopping methods used in the original call to \code{ps()}, \code{mnps()}, or \code{iptw()}. Examples include \code{"es.max"} or \code{"ks.mean"} for \code{ps} and \code{mnps} objects. \code{bal.tab} will assess balance for the weights created by those stopping methods. The names can be abbreviated as long as the abbreviations are specific enough. If no stopping methods are provided, \code{bal.tab} will default to displaying balance for all available stopping methods. Ignored for \code{ps.cont} objects.
}
  \item{stats, int, poly, addl, data, continuous, binary, thresholds, weights, cluster, imp, pairwise, abs, subset, quick, \dots}{
see \fun{bal.tab} for details.

See below for special notes on the \code{distance}, \code{s.d.denom}, and \code{s.weights} arguments.
}

The following arguments have special notes when used with these input objects:

  \item{distance}{
the propensity scores generated by \code{ps()} and \code{iptw()} (but not \code{mnps()} or \code{ps.cont()}) are automatically included and named "prop.score.{stop.method}".
}
  \item{s.d.denom}{
if not specified, for \code{ps} objects, \code{bal.tab()} will use "treated" if the estimand of the call to \code{ps()} is the ATT and "pooled" if the estimand is the ATE; for \code{mnps} objects, \code{bal.tab()} will use "treated" if \code{treatATT} was specified in the original call to \code{mnps} and "pooled" otherwise. Use "all" to get the same values computed by \code{bal.table} in \pkg{twang}. Abbreviations allowed.
}
  \item{s.weights}{
if \code{sampw} was supplied in the call to \code{ps()}, \code{mnps()}, \code{iptw()}, or \code{ps.cont()}, they will automatically be supplied to \code{s.weights} and do not need be specified again (though there is no harm if they are).
}
}
\details{
\code{bal.tab.ps()} generates a list of balance summaries for the input object given, and functions similarly to \pkgfun{twang}{bal.table}.
}
\value{
For binary or continuous point treatments, if clusters are not specified, an object of class \code{"bal.tab"} containing balance summaries for the \code{ps} object. See \fun{bal.tab} for details.

If clusters are specified, an object of class \code{"bal.tab.cluster"} containing balance summaries within each cluster and a summary of balance across clusters. See \code{\link[=class-bal.tab.cluster]{bal.tab.cluster}} for details.

If \code{mnps()} is used with multi-category treatments, an object of class \code{"bal.tab.multi"} containing balance summaries for each pairwise treatment comparison and a summary of balance across pairwise comparisons. See \code{\link[=class-bal.tab.multi]{bal.tab.multi}} for details.
}
\note{
The function \pkgfun{twang}{bal.table} in \pkg{twang} performs a similar function. The variances used in the denominator of the standardized mean difference are weighted and computed using \code{survey::svyvar()} in \pkg{twang} and are unweighted here (except when \code{s.weights} are specified, in which case \code{\link{col_w_sd}} is used). \pkg{twang} also uses "all" as the default \code{s.d.denom} when the estimand is the ATE; the default here is "pooled". For this reason, results may differ slightly between the two packages. 
}

\author{
Noah Greifer 
}

\seealso{
\fun{bal.tab} for details of calculations.

\code{\link[=class-bal.tab.cluster]{bal.tab.cluster}} for more information on clustered data.

\code{\link[=class-bal.tab.multi]{bal.tab.multi}} for more information on multi-category treatments.

\code{\link[=class-bal.tab.msm]{bal.tab.msm}} for more information on longitudinal treatments.
}
\examples{\dontshow{if (requireNamespace("twang", quietly = TRUE)) force(\{ # examplesIf}
\donttest{library(twang); data("lalonde", package = "cobalt")

## Using ps() for generalized boosted modeling
ps.out <- ps(treat ~ age + educ + married + race +
             nodegree + re74 + re75, data = lalonde, 
             stop.method = c("ks.mean", "es.mean"), 
             estimand = "ATT", verbose = FALSE)
             
bal.tab(ps.out, stop.method = "ks.mean", un = TRUE, 
        m.threshold = .1, disp.ks = TRUE)
}
\dontshow{\}) # examplesIf}}
\keyword{tables}
