% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmsaf.stats.R
\name{cmsaf.stats}
\alias{cmsaf.stats}
\title{Calculates the rmse, mae, bias, correlation in grid space of two NetCDF files.
Designed for the CM SAF R Toolbox.}
\usage{
cmsaf.stats(
  var1,
  var2,
  infile1,
  infile2,
  outfile,
  nc34 = 4,
  overwrite = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{var1}{Name of NetCDF variable of the first file (character).}

\item{var2}{Name of NetCDF variable of the second file (character).}

\item{infile1}{Filename of first input NetCDF file. This may include
the directory (character).}

\item{infile2}{Filename of second input NetCDF file. This may include
the directory (character).}

\item{outfile}{Filename of output csv file. This may include the directory
(character).}

\item{nc34}{NetCDF version of input file. Default output is NetCDFv4.}

\item{overwrite}{logical; should existing output file be overwritten?; Default: FALSE}

\item{verbose}{logical; if TRUE, progress messages are shown}
}
\value{
A csv file including the rmse, mae, bias and correlation in grid space
is written.
}
\description{
Calculates the rmse, mae, bias, correlation in grid space of two NetCDF files.
Designed for the CM SAF R Toolbox.
}
\seealso{
Other metrics: 
\code{\link{cmsaf.stats.station.data}()}
}
\concept{metrics}
