% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/romberg.R
\name{romberg}
\alias{romberg}
\title{Romberg Integration}
\usage{
romberg(f, a, b, m, tab = FALSE)
}
\arguments{
\item{f}{function to integrate}

\item{a}{the lowerbound of integration}

\item{b}{the upperbound of integration}

\item{m}{the maximum number of iterations}

\item{tab}{if \code{TRUE}, return the table of values}
}
\value{
the value of the integral
}
\description{
Romberg's adaptive integration
}
\details{
The \code{romberg} function uses Romberg's rule to calculate the
integral of the function \code{f} over the interval from \code{a}
to \code{b}.  The parameter \code{m} sets the number of intervals
to use when evaluating.  Additional options are passed to the
function \code{f} when evaluating.
}
\examples{
f <- function(x) { sin(x)^2 + log(x)}
romberg(f, 1, 10, m = 3)
romberg(f, 1, 10, m = 5)
romberg(f, 1, 10, m = 10)

}
\seealso{
Other integration: 
\code{\link{adaptint}()},
\code{\link{gaussint}()},
\code{\link{giniquintile}()},
\code{\link{mcint}()},
\code{\link{midpt}()},
\code{\link{revolution-solid}},
\code{\link{simp38}()},
\code{\link{simp}()},
\code{\link{trap}()}

Other newton-cotes: 
\code{\link{adaptint}()},
\code{\link{giniquintile}()},
\code{\link{midpt}()},
\code{\link{simp38}()},
\code{\link{simp}()},
\code{\link{trap}()}
}
\concept{integration}
\concept{newton-cotes}
