% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refmatrix.R
\name{refmatrix}
\alias{refmatrix}
\alias{rrefmatrix}
\alias{solvematrix}
\title{Matrix to Row Echelon Form}
\usage{
refmatrix(m)

rrefmatrix(m)

solvematrix(A, b)
}
\arguments{
\item{m}{a matrix}

\item{A}{a square matrix representing the coefficients of a linear
system in \code{solvematrix}}

\item{b}{a vector representing the right-hand side of the linear
system in \code{solvematrix}}
}
\value{
the modified matrix
}
\description{
Transform a matrix to row echelon form.
}
\details{
\code{refmatrix} reduces a matrix to row echelon form.  This is not a
reduced row echelon form, though that can be easily calculated from
the diagonal.  This function works on non-square matrices.

\code{rrefmatrix} returns the reduced row echelon matrix.

\code{solvematrix} solves a linear system using \code{rrefmatrix}.
}
\examples{
A <- matrix(c(1, 2, -7, -1, -1, 1, 2, 1, 5), 3)
refmatrix(A)

}
\seealso{
Other linear: 
\code{\link{choleskymatrix}()},
\code{\link{detmatrix}()},
\code{\link{gdls}()},
\code{\link{invmatrix}()},
\code{\link{iterativematrix}},
\code{\link{lumatrix}()},
\code{\link{rowops}},
\code{\link{tridiagmatrix}()},
\code{\link{vecnorm}()}
}
\concept{linear}
