% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choosemaxit.R
\name{choosemaxit}
\alias{choosemaxit}
\title{Diagnostic plot for the number of iterations used in sequential imputation methods}
\usage{
choosemaxit(
  output,
  plotvars = NULL,
  plotm = 1:5,
  cex = 0.3,
  pch = 16,
  type = "b",
  xlab = "iterations",
  ylab = "var",
  layout = NULL
)
}
\arguments{
\item{output}{an outpout from the imputedata function}

\item{plotvars}{index of variables for which a curve is plotted}

\item{plotm}{a vector indicating which imputed datasets must be plotted}

\item{cex}{a numerical vector giving the amount by which plotting characters and symbols should be scaled relative to the default}

\item{pch}{a vector of plotting characters or symbols}

\item{type}{what type of plot should be drawn}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{layout}{a vector of the form c(nrow, ncol)}
}
\value{
No return value
}
\description{
The \code{choosemaxit} function plots the within and between variance for each variable (specified in \code{plotvars}) against the iteration number for each of the replications (specified in \code{plotm}).
}
\examples{
data(wine)
set.seed(123456)
wine.na <- wine
wine.na$cult <- NULL
wine.na <- as.matrix(wine.na)
wine.na[sample(seq(length(wine.na)), size = ceiling(length(wine.na)/3))] <- NA
nb.clust <- 3 # number of clusters
m <- 3 # number of imputed data sets
maxit <- 50 # number of iterations for FCS imputation
\donttest{
res.imp <- imputedata(data.na = wine.na, method = "FCS-homo",
                      nb.clust = nb.clust, m = m, maxit = maxit)
choosemaxit(res.imp, cex = .7)
}
}
