/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.cbui;

import com.amazonaws.utils.PropertyBundle;
import com.amazonaws.utils.PropertyKeys;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AmazonFPSCBUIPipeline {
    protected static final String HTTP_GET_METHOD = "GET";
    protected static final String UTF_8_Encoding = "UTF-8";
    public static final String SIGNATURE_VERSION_KEYNAME = "signatureVersion";
    public static final String SIGNATURE_METHOD_KEYNAME = "signatureMethod";
    public static final String SIGNATURE_KEYNAME = "signature";
    public static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    public static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    public static final String SIGNATURE_VERSION_1 = "2";
    public static final String SIGNATURE_VERSION_2 = "2";
    public static final String NewLine = "\n";
    public static final String EmptyUriPath = "/";
    public static final String Equals = "=";
    public static final String And = "&";
    protected String awsAccessKey;
    protected String awsSecretKey;
    protected static String CBUI_URL = PropertyBundle.getProperty(PropertyKeys.CBUI_SERVICE_END_POINT);
    protected static String VERSION = "2009-01-09";
    protected static String SIGNATURE_VERSION = "2";
    protected static String SIGNATURE_METHOD = "HmacSHA256";
    protected Map<String, String> parameters = new HashMap<String, String>();

    protected AmazonFPSCBUIPipeline(String pipelineName, String accessKey, String secretKey) {
        if (pipelineName == null || accessKey == null || secretKey == null) {
            throw new RuntimeException("PipelineName or AWSAccessKey or AWSSecretKey can not be empty.");
        }
        this.awsSecretKey = secretKey;
        this.awsAccessKey = accessKey;
        this.addParameter("callerKey", this.awsAccessKey);
        this.addParameter("pipelineName", pipelineName);
        this.addParameter("version", VERSION);
        this.addParameter(SIGNATURE_VERSION_KEYNAME, SIGNATURE_VERSION);
        this.addParameter(SIGNATURE_METHOD_KEYNAME, SIGNATURE_METHOD);
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void addOptionalParameters(Map<String, String> params) {
        this.parameters.putAll(params);
    }

    private String constructUrl(Map<String, String> parameters) throws MalformedURLException, SignatureException, UnsupportedEncodingException {
        if (parameters == null || parameters.isEmpty()) {
            throw new RuntimeException("Parameters can not be empty.");
        }
        String hostHeader = this.getHostHeader(CBUI_URL);
        String requestURI = this.getRequestURI(CBUI_URL);
        String signature = this.signParameters(parameters, HTTP_GET_METHOD, hostHeader, requestURI);
        parameters.put(SIGNATURE_KEYNAME, signature);
        String queryString = this.constructQueryString(parameters);
        return CBUI_URL + "?" + queryString;
    }

    private String constructQueryString(Map<String, String> parameters) throws UnsupportedEncodingException {
        StringBuilder queryStringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = URLEncoder.encode(entry.getKey(), UTF_8_Encoding);
            String value = URLEncoder.encode(entry.getValue(), UTF_8_Encoding);
            queryStringBuilder.append(key);
            queryStringBuilder.append(Equals);
            queryStringBuilder.append(value);
            queryStringBuilder.append(And);
        }
        String queryString = queryStringBuilder.toString();
        if (queryString.endsWith(And)) {
            queryString = queryString.substring(0, queryString.length() - 1);
        }
        return queryString;
    }

    private String getHostHeader(String urlEndPoint) throws MalformedURLException {
        URL url = new URL(urlEndPoint);
        int port = url.getPort();
        if (port != -1 && ("HTTPS".equalsIgnoreCase(url.getProtocol()) && port == 443 || "HTTP".equalsIgnoreCase(url.getProtocol()) && port == 80)) {
            port = -1;
        }
        return url.getHost().toLowerCase() + (port != -1 ? ":" + port : "");
    }

    private String getRequestURI(String urlEndPoint) throws MalformedURLException {
        URL url = new URL(urlEndPoint);
        String requestURI = url.getPath();
        if (requestURI == null || requestURI.equals("")) {
            requestURI = EmptyUriPath;
        }
        return requestURI;
    }

    protected void validateCommonMandatoryParameters(Map<String, String> parameters) {
        if (!parameters.containsKey("pipelineName")) {
            throw new RuntimeException("pipelineName is missing in parameters.");
        }
        if (!parameters.containsKey("version")) {
            throw new RuntimeException("version is missing in parameters.");
        }
        if (!parameters.containsKey("returnURL")) {
            throw new RuntimeException("returnURL is missing in parameters.");
        }
        if (!parameters.containsKey("callerReference")) {
            throw new RuntimeException("callerReference is missing in parameters.");
        }
    }

    public String signParameters(Map<String, String> parameters, String httpMethod, String host, String requestURI) throws SignatureException {
        String signatureVersion = parameters.get(SIGNATURE_VERSION_KEYNAME);
        String algorithm = HMAC_SHA1_ALGORITHM;
        String stringToSign = null;
        String signature = null;
        if (!"2".equals(signatureVersion)) {
            throw new SignatureException("Invalid Signature Version");
        }
        algorithm = parameters.get(SIGNATURE_METHOD_KEYNAME);
        stringToSign = this.calculateStringToSignV2(parameters, httpMethod, host, requestURI);
        signature = AmazonFPSCBUIPipeline.sign(stringToSign, this.awsSecretKey, algorithm);
        return signature;
    }

    private String calculateStringToSignV2(Map<String, String> parameters, String httpMethod, String hostHeader, String requestURI) throws SignatureException {
        StringBuffer stringToSign = new StringBuffer("");
        if (httpMethod == null) {
            throw new SignatureException("HttpMethod cannot be null");
        }
        stringToSign.append(httpMethod);
        stringToSign.append(NewLine);
        if (hostHeader == null) {
            stringToSign.append("");
        } else {
            stringToSign.append(hostHeader.toLowerCase());
        }
        stringToSign.append(NewLine);
        if (requestURI == null || requestURI.length() == 0) {
            stringToSign.append(EmptyUriPath);
        } else {
            stringToSign.append(AmazonFPSCBUIPipeline.urlEncode(requestURI, true));
        }
        stringToSign.append(NewLine);
        TreeMap<String, String> sortedParamMap = new TreeMap<String, String>();
        sortedParamMap.putAll(parameters);
        Iterator pairs = sortedParamMap.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry pair = pairs.next();
            if (((String)pair.getKey()).equalsIgnoreCase(SIGNATURE_KEYNAME)) continue;
            stringToSign.append(AmazonFPSCBUIPipeline.urlEncode((String)pair.getKey(), false));
            stringToSign.append(Equals);
            stringToSign.append(AmazonFPSCBUIPipeline.urlEncode((String)pair.getValue(), false));
            if (!pairs.hasNext()) continue;
            stringToSign.append(And);
        }
        return stringToSign.toString();
    }

    private static String urlEncode(String value, boolean path) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, UTF_8_Encoding).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            if (path) {
                encoded = encoded.replace("%2F", EmptyUriPath);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return encoded;
    }

    private static String sign(String data, String key, String signatureMethod) throws SignatureException {
        String signature = "";
        try {
            Mac mac = Mac.getInstance(signatureMethod);
            mac.init(new SecretKeySpec(key.getBytes(), signatureMethod));
            signature = new String(Base64.encodeBase64((byte[])mac.doFinal(data.getBytes(UTF_8_Encoding))));
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate signature: " + e.getMessage(), e);
        }
        return signature;
    }

    protected abstract void validateParameters(Map<String, String> var1);

    public String getUrl() throws MalformedURLException, SignatureException, UnsupportedEncodingException {
        this.validateCommonMandatoryParameters(this.parameters);
        this.validateParameters(this.parameters);
        return this.constructUrl(this.parameters);
    }
}

