/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.CountPendingActivityTasksRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountPendingActivityTasksRequestMarshaller
implements Marshaller<Request<CountPendingActivityTasksRequest>, CountPendingActivityTasksRequest> {
    @Override
    public Request<CountPendingActivityTasksRequest> marshall(CountPendingActivityTasksRequest countPendingActivityTasksRequest) {
        if (countPendingActivityTasksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CountPendingActivityTasksRequest> request = new DefaultRequest<CountPendingActivityTasksRequest>(countPendingActivityTasksRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.CountPendingActivityTasks";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            TaskList taskList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (countPendingActivityTasksRequest.getDomain() != null) {
                jsonWriter.key("domain").value(countPendingActivityTasksRequest.getDomain());
            }
            if ((taskList = countPendingActivityTasksRequest.getTaskList()) != null) {
                jsonWriter.key("taskList").object();
                if (taskList.getName() != null) {
                    jsonWriter.key("name").value(taskList.getName());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

