/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.KeysAndAttributes;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchGetItemRequestMarshaller
implements Marshaller<Request<BatchGetItemRequest>, BatchGetItemRequest> {
    @Override
    public Request<BatchGetItemRequest> marshall(BatchGetItemRequest batchGetItemRequest) {
        if (batchGetItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetItemRequest> request = new DefaultRequest<BatchGetItemRequest>(batchGetItemRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20111205.BatchGetItem";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (batchGetItemRequest.getRequestItems() != null) {
                jsonWriter.key("RequestItems").object();
                for (Map.Entry<String, KeysAndAttributes> requestItemsListValue : batchGetItemRequest.getRequestItems().entrySet()) {
                    List<String> attributesToGetList;
                    if (requestItemsListValue.getValue() == null) continue;
                    jsonWriter.key(requestItemsListValue.getKey());
                    jsonWriter.object();
                    List<Key> keysList = requestItemsListValue.getValue().getKeys();
                    if (keysList != null && keysList.size() > 0) {
                        jsonWriter.key("Keys").array();
                        for (Key keysListValue : keysList) {
                            AttributeValue rangeKeyElement;
                            jsonWriter.object();
                            AttributeValue hashKeyElement = keysListValue.getHashKeyElement();
                            if (hashKeyElement != null) {
                                List<String> nSList;
                                List<String> sSList;
                                jsonWriter.key("HashKeyElement").object();
                                if (hashKeyElement.getS() != null) {
                                    jsonWriter.key("S").value(hashKeyElement.getS());
                                }
                                if (hashKeyElement.getN() != null) {
                                    jsonWriter.key("N").value(hashKeyElement.getN());
                                }
                                if ((sSList = hashKeyElement.getSS()) != null && sSList.size() > 0) {
                                    jsonWriter.key("SS").array();
                                    for (String sSListValue : sSList) {
                                        jsonWriter.value(sSListValue);
                                    }
                                    jsonWriter.endArray();
                                }
                                if ((nSList = hashKeyElement.getNS()) != null && nSList.size() > 0) {
                                    jsonWriter.key("NS").array();
                                    for (String nSListValue : nSList) {
                                        jsonWriter.value(nSListValue);
                                    }
                                    jsonWriter.endArray();
                                }
                                jsonWriter.endObject();
                            }
                            if ((rangeKeyElement = keysListValue.getRangeKeyElement()) != null) {
                                List<String> nSList;
                                List<String> sSList;
                                jsonWriter.key("RangeKeyElement").object();
                                if (rangeKeyElement.getS() != null) {
                                    jsonWriter.key("S").value(rangeKeyElement.getS());
                                }
                                if (rangeKeyElement.getN() != null) {
                                    jsonWriter.key("N").value(rangeKeyElement.getN());
                                }
                                if ((sSList = rangeKeyElement.getSS()) != null && sSList.size() > 0) {
                                    jsonWriter.key("SS").array();
                                    for (String sSListValue : sSList) {
                                        jsonWriter.value(sSListValue);
                                    }
                                    jsonWriter.endArray();
                                }
                                if ((nSList = rangeKeyElement.getNS()) != null && nSList.size() > 0) {
                                    jsonWriter.key("NS").array();
                                    for (String nSListValue : nSList) {
                                        jsonWriter.value(nSListValue);
                                    }
                                    jsonWriter.endArray();
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if ((attributesToGetList = requestItemsListValue.getValue().getAttributesToGet()) != null && attributesToGetList.size() > 0) {
                        jsonWriter.key("AttributesToGet").array();
                        for (String attributesToGetListValue : attributesToGetList) {
                            jsonWriter.value(attributesToGetListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

