/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.interceptors.Decorator;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryCallable;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryInterceptorBase;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryInterceptorVoid;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryInterceptorWithResult;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryPolicy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryDecorator
implements Decorator {
    private final RetryPolicy retryPolicy;

    public RetryDecorator(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Override
    public final <V> V decorate(Class<V> interfaces, V object) {
        Class[] interfazes = new Class[]{interfaces};
        return (V)Proxy.newProxyInstance(object.getClass().getClassLoader(), interfazes, (InvocationHandler)new DecoratorInvocationHandler(object, this.retryPolicy));
    }

    @Override
    public final <V> V decorate(Class<?>[] interfaces, V object) {
        return (V)Proxy.newProxyInstance(object.getClass().getClassLoader(), interfaces, (InvocationHandler)new DecoratorInvocationHandler(object, this.retryPolicy));
    }

    protected boolean isDecorated(Method method, Object[] args) {
        return !method.getDeclaringClass().equals(Object.class);
    }

    private final class DecoratorInvocationHandler
    implements InvocationHandler {
        private final Object object;
        private final RetryPolicy retryPolicy;

        public DecoratorInvocationHandler(Object object, RetryPolicy retryPolicy) {
            this.object = object;
            this.retryPolicy = retryPolicy;
        }

        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            try {
                if (!RetryDecorator.this.isDecorated(method, args)) {
                    return method.invoke(this.object, args);
                }
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
            RetryCallable retryCallable = new RetryCallable(){

                public Promise call() throws Throwable {
                    return (Promise)method.invoke(DecoratorInvocationHandler.this.object, args);
                }
            };
            boolean isVoidReturnType = Void.TYPE.equals(method.getReturnType());
            RetryInterceptorBase interceptor = null;
            interceptor = isVoidReturnType ? new RetryInterceptorVoid(retryCallable, this.retryPolicy) : new RetryInterceptorWithResult(retryCallable, this.retryPolicy);
            return interceptor.execute();
        }
    }
}

