/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui.networkspec;

import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import nbl.utilj.NumberFormatter;
import ppe.ec2.Ec2InstanceType;
import ppe.gui.networkspec.Choice;
import ppe.gui.networkspec.RadioButtonCC;

public class InstanceTypeChoice
extends Choice {
    Ec2InstanceType instanceType;

    public InstanceTypeChoice(Ec2InstanceType instanceType) {
        this.instanceType = instanceType;
    }

    @Override
    public String getChoiceType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Object getValue() {
        return this.instanceType.instanceType.toString();
    }

    @Override
    public String getLabel() {
        return this.instanceType.instanceType.toString();
    }

    @Override
    public void createCC() {
        this.cc = new RadioButtonCC(this.getLabel());
        this.cc.setEnabled(this.enabled);
        this.cc.setSelected(this.selected);
    }

    @Override
    public int getNColumns() {
        return 4;
    }

    @Override
    public String getColumnName(int iCol) {
        switch (iCol) {
            case 0: {
                return " ";
            }
            case 1: {
                return "Cores";
            }
            case 2: {
                return "GB ram";
            }
            case 3: {
                return "Cluster";
            }
        }
        return "";
    }

    @Override
    public Object getValue(int iCol) {
        switch (iCol) {
            case 0: {
                return this.getValue();
            }
            case 1: {
                return Integer.toString(this.instanceType.nCores);
            }
            case 2: {
                return NumberFormatter.f1((double)this.instanceType.ramGB);
            }
            case 3: {
                return this.booToString(this.instanceType.clusterSupport);
            }
        }
        return "";
    }

    private String booToString(boolean b) {
        if (b) {
            return "yes";
        }
        return "no";
    }

    @Override
    public JComponent getComponent(int iCol) {
        JLabel x = new JLabel(this.getValue(iCol).toString());
        return x;
    }

    @Override
    public double getColumnWeight(int iCol) {
        switch (iCol) {
            case 0: {
                return 0.4;
            }
            case 1: {
                return 0.2;
            }
            case 2: {
                return 0.3;
            }
            case 3: {
                return 0.3;
            }
        }
        return 0.0;
    }

    @Override
    public int getGridBagAnchor(int iCol) {
        switch (iCol) {
            case 0: {
                return 512;
            }
            case 1: {
                return 768;
            }
            case 2: {
                return 768;
            }
            case 3: {
                return 768;
            }
        }
        return 0;
    }

    @Override
    public Insets getInsets(int iCol) {
        switch (iCol) {
            case 0: {
                return new Insets(0, 0, 0, 8);
            }
            case 1: {
                return new Insets(0, 0, 0, 12);
            }
            case 2: {
                return new Insets(0, 0, 0, 12);
            }
            case 5: {
                return new Insets(0, 0, 0, 0);
            }
        }
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public String getToolTip() {
        StringBuilder s = new StringBuilder("<html>\n");
        s.append("<u>" + this.instanceType.instanceType.toString() + "</u><br>");
        s.append("Cores: " + this.instanceType.nCores + "<br>");
        s.append("Memory (gb): " + NumberFormatter.f1((double)this.instanceType.ramGB) + "<br>");
        s.append("Virtualization type: " + this.instanceType.vt.toString() + "<br>");
        s.append("Cluster instance: " + this.booToString(this.instanceType.clusterSupport) + "<br>");
        s.append(this.instanceType.description);
        s.append("\n</html>");
        return s.toString();
    }

    private String toNS(Object x) {
        if (x != null) {
            return x.toString();
        }
        return " ";
    }
}

