\name{cv.clogitL1}
\alias{cv.clogitL1}
\title{Cross validation of conditional logistic regression with elastic net penalties}
\description{
 Find the best of a sequence of conditional logistic regression models with lasso or elastic net penalties using cross validation
}

\usage{
 cv.clogitL1 (clObj, numFolds=10)
}

\arguments{
\item{clObj}{an object of type \code{clogitL1} on which we do cross validation.}
\item{numFolds}{the number of folds used in cross validation. Defaults to the minimum of 10 or the number of observations}
}

\details{
Performs \code{numFolds}-fold cross validation on an object of type \code{clogitL1}. Using the sequence of regularisation parameters generated by \code{clObj}, the function chooses \emph{strata} to leave out randomly. The penalised conditional logistic regression model is fit to the non-left-out strata in turn and its deviance compared to an out-of-sample deviance computed on the left-out strata. Fitting models to individual non-left-out strata proceeds using the cyclic coordinate descent-warm start-strong rule type algorith used in \code{clogitL1}, only with a prespecified sequence of \eqn{\lambda}.
}

\value{
An object of type \code{cv.clogitL1} with the following fields:

\item{cv_dev}{matrix of size \code{numLambda}-by-\code{numFolds} containing the CV deviance in each fold for each value of the regularisation parameter.}
\item{lambda}{vector of regularisation parameters.}
\item{folds}{vector showing the folds membership of each observation.}
\item{mean_cv}{vector containing mean CV deviances for each value of the regularisation parameter.}
\item{se_cv}{vector containing an estimate of the standard error of the CV deviance at each value of the regularisation parameter.}
\item{minCV_lambda}{value of the regularisation parameter at which we have minimum \code{mean_cv}}
\item{minCV1se_lambda}{value of the regularisation parameter corresponding to the 1-SE rule. Selects the simplest model with estimate CV within 1 standard deviation of the minimum cv.}
\item{nz_beta}{number of nonzero parameter estimates at each value of the regularisation parameter.}
}

\seealso{
 \code{\link{clogitL1}}, \code{\link{plot.cv.clogitL1}}
}
\examples{
set.seed(142)

# data parameters
K = 10 # number of strata
n = 5 # number in strata
m = 2 # cases per stratum
p = 20 # predictors

# generate data
y = rep(c(rep(1, m), rep(0, n-m)), K)
X = matrix (rnorm(K*n*p, 0, 1), ncol = p) # pure noise
strata = sort(rep(1:K, n))

par(mfrow = c(1,2))
# fit the conditional logistic model
clObj = clogitL1(y, X, strata)
plot(clObj, logX=TRUE)

# cross validation
clcvObj = cv.clogitL1(clObj)
plot(clcvObj)
}