% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-day.R
\name{year_month_day}
\alias{year_month_day}
\title{Calendar: year-month-day}
\usage{
year_month_day(
  year,
  month = NULL,
  day = NULL,
  hour = NULL,
  minute = NULL,
  second = NULL,
  subsecond = NULL,
  ...,
  subsecond_precision = NULL
)
}
\arguments{
\item{year}{\verb{[integer]}

The year. Values \verb{[-32767, 32767]} are generally allowed.}

\item{month}{\verb{[integer / NULL]}

The month. Values \verb{[1, 12]} are allowed.}

\item{day}{\verb{[integer / "last" / NULL]}

The day of the month. Values \verb{[1, 31]} are allowed.

If \code{"last"}, then the last day of the month is returned.}

\item{hour}{\verb{[integer / NULL]}

The hour. Values \verb{[0, 23]} are allowed.}

\item{minute}{\verb{[integer / NULL]}

The minute. Values \verb{[0, 59]} are allowed.}

\item{second}{\verb{[integer / NULL]}

The second. Values \verb{[0, 59]} are allowed.}

\item{subsecond}{\verb{[integer / NULL]}

The subsecond. If specified, \code{subsecond_precision} must also be specified
to determine how to interpret the \code{subsecond}.

If using milliseconds, values \verb{[0, 999]} are allowed.

If using microseconds, values \verb{[0, 999999]} are allowed.

If using nanoseconds, values \verb{[0, 999999999]} are allowed.}

\item{...}{These dots are for future extensions and must be empty.}

\item{subsecond_precision}{\verb{[character(1) / NULL]}

The precision to interpret \code{subsecond} as. One of: \code{"millisecond"},
\code{"microsecond"}, or \code{"nanosecond"}.}
}
\value{
A year-month-day calendar vector.
}
\description{
\code{year_month_day()} constructs the most common calendar type using the
Gregorian year, month, day, and time of day components.
}
\details{
Fields are recycled against each other using
\link[vctrs:vector_recycling_rules]{tidyverse recycling rules}.

Fields are collected in order until the first \code{NULL} field is located. No
fields after the first \code{NULL} field are used.
}
\examples{
# Just the year
x <- year_month_day(2019:2025)

# Year-month type
year_month_day(2020, 1:12)

# The most common use case involves year, month, and day fields
x <- year_month_day(2020, clock_months$january, 1:5)
x

# Precision can go all the way out to nanosecond
year_month_day(2019, 1, 2, 2, 40, 45, 200, subsecond_precision = "nanosecond")
}
