% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataManipulation-processData.R
\name{processData}
\alias{processData}
\title{Run specified data processing steps.}
\usage{
processData(data, processing, labelVars = NULL, ...)
}
\arguments{
\item{data}{Data.frame with data.}

\item{processing}{List with details of the steps to process the data.
Each element in the list should be a named list containing the parameters
for the specific processing function. The name specifies which processing
step, among: 
\itemize{
\item{'annotate' for \code{\link{annotateData}} (\code{annotations} parameter)}
\item{'filter' for \code{\link{filterData}} (\code{filters} parameter)}
\item{'transform' for \code{\link{transformData}} (\code{transformations} parameter)}
}}

\item{labelVars}{Named character vector containing variable labels.}

\item{...}{Any parameters passed to all processing functions
(if this parameter is available).
If specified, these parameters shouldn't be specified also in \code{processing}.}
}
\value{
Data.frame with processed \code{data},
with extra attribute: \code{labelVars}.
}
\description{
This function is intended to automate all data processing
steps for use in the 'clinDataReview' reports using config files.
}
\author{
Laure Cougnaud
}
