% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/autowin.R
\name{autowin}
\alias{autowin}
\title{Test for auto-correlation in climate.}
\usage{
autowin(reference, Xvar, CDate, BDate, furthest, closest, STAT, FIXED,
  cutoff.day, cutoff.month, CMISSING = FALSE, CINTERVAL = "D")
}
\arguments{
\item{reference}{Reference climate data to be compared. Generated by functions
\code{\link{singlewin}} or \code{\link{climatewin}}.}

\item{Xvar}{The climate variable of interest. Please specify the parent
environment and variable name (e.g. Climate$Temp).}

\item{CDate}{The climate date variable (dd/mm/yyyy). Please specify the parent
environment and variable name (e.g. Climate$Date).}

\item{BDate}{The biological date variable (dd/mm/yyyy). Please specify the
parent environment and variable name (e.g. Biol$Date).}

\item{furthest}{The furthest number of time intervals (set by CINTERVAL) back
from the cutoff date or biological record to include in your climate window
search.}

\item{closest}{The closest number of time intervals (set by CINTERVAL) back
from the cutoff date or biological record to include in your climate window
search.}

\item{STAT}{The aggregate statistic used to analyse the climate data. Can
currently use basic R statistics (e.g. mean, min), as well as slope.
Additional aggregate statistics can be created using the format function(x)
(...). See parameter FUN in \code{\link{apply}} for more detail.}

\item{FIXED}{TRUE or FALSE, whether you wish the climate window to be variable
(e.g. the number of days before each biological record is measured) or fixed
(e.g. number of days before a set point in time).}

\item{cutoff.day,cutoff.month}{If FIXED is TRUE, the day and month of the
year from which the fixed window analysis will start.}

\item{CMISSING}{TRUE or FALSE, determines what should be done if there are
missing climate data. If FALSE, the function will not run if missing climate
data is encountered. If TRUE, any records affected by missing climate data
will be removed from climate window analysis.}

\item{CINTERVAL}{The resolution at which climate window analysis will be
conducted. May be days ("D"), weeks ("W"), or months ("M"). Note the units
of parameters 'furthest' and 'closest' will differ with the choice of
CINTERVAL.}
}
\value{
Will return a data frame showing the correlation between the climate
 in each fitted window and the chosen reference window.
}
\description{
Tests the correlation between the climate in a specified climate window and
other fitted climate windows.
}
\examples{
\dontrun{

# Test for auto-correlation using 'Mass' and 'MassClimate' data frames

data(Mass)
data(MassClimate)

# Fit a single climate window using the datasets Mass and MassClimate.

single <- singlewin(Xvar = MassClimate$Temp, CDate = MassClimate$Date, BDate = Mass$Date,
                    baseline = lm(Mass$Mass ~ 1), furthest = 72, closest = 15,
                    STAT = "mean", FUNC = "L",
                    FIXED = TRUE, cutoff.day = 20, cutoff.month = 5,
                    CMISSING = FALSE, CINTERVAL = "D")

# Test the autocorrelation between the climate in this single window and other climate windows.

auto <- autowin(reference = single[[2]]$temporary,
                Xvar  = MassClimate$Temp, CDate = MassClimate$Date, BDate = Mass$Date,
                furthest = 365, closest = 0, STAT = "mean",
                FIXED = TRUE, cutoff.day = 20, cutoff.month = 5,
                CMISSING = FALSE, CINTERVAL = "D")

# View the output
head(auto)
}
}
\author{
Liam D. Bailey and Martijn van de Pol
}

