% Generated by roxygen2 (4.0.2): do not edit by hand
\name{climdexInput.raw}
\alias{climdexInput.raw}
\title{Any of tmin (daily minimum temperature), tmax (daily maximum temperature),
tavg (daily mean temperature), and prec (daily precipitation) can be passed
in. tavg will be derived from the mean of tmax and tmin if it is not
supplied. If any of tmin, tmax, and prec are not supplied, the set of
indices which can be calculated will be limited to indices which do not
involve the missing variables.}
\usage{
climdexInput.raw(tmax = NULL, tmin = NULL, prec = NULL,
  tmax.dates = NULL, tmin.dates = NULL, prec.dates = NULL,
  base.range = c(1961, 1990), n = 5, northern.hemisphere = TRUE,
  tavg = NULL, tavg.dates = NULL, quantiles = NULL, temp.qtiles = c(0.1,
  0.9), prec.qtiles = c(0.95, 0.99), max.missing.days = c(annual = 15,
  monthly = 3), min.base.data.fraction.present = 0.1)
}
\arguments{
\item{tmax}{Daily maximum temperature data.}

\item{tmin}{Daily minimum temperature data.}

\item{prec}{Daily total precipitation data.}

\item{tmax.dates}{Dates for the daily maximum temperature data.}

\item{tmin.dates}{Dates for the daily minimum temperature data.}

\item{prec.dates}{Dates for the daily total precipitation data.}

\item{base.range}{Years to use for the baseline.}

\item{n}{Number of days to use as window for daily quantiles.}

\item{northern.hemisphere}{Whether this point is in the northern hemisphere.}

\item{tavg}{Daily mean temperature data.}

\item{tavg.dates}{Dates for the daily mean temperature data.}

\item{quantiles}{Threshold quantiles for supplied variables.}

\item{temp.qtiles}{Quantiles to calculate for temperature variables}

\item{prec.qtiles}{Quantiles to calculate for precipitation}

\item{max.missing.days}{Vector containing thresholds for number of days
allowed missing per year (annual) and per month (monthly).}

\item{min.base.data.fraction.present}{Minimum fraction of base data that must
be present for quantile to be calculated for a particular day}
}
\value{
An object of class \code{\link{climdexInput-class}} for use with
other climdex methods.
}
\description{
For all data supplied, the associated dates must also be supplied.
}
\note{
Units are assumed to be mm/day for precipitation and degrees Celsius
for temperature. No units conversion is performed internally.
}
\examples{
library(PCICt)

## Create a climdexInput object from some data already loaded in and
## ready to go.

## Parse the dates into PCICt.
tmax.dates <- as.PCICt(do.call(paste, ec.1018935.tmax[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
tmin.dates <- as.PCICt(do.call(paste, ec.1018935.tmin[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
prec.dates <- as.PCICt(do.call(paste, ec.1018935.prec[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")

## Load the data in.
ci <- climdexInput.raw(ec.1018935.tmax$MAX_TEMP,
ec.1018935.tmin$MIN_TEMP, ec.1018935.prec$ONE_DAY_PRECIPITATION,
tmax.dates, tmin.dates, prec.dates, base.range=c(1971, 2000))
}
\references{
\url{http://etccdi.pacificclimate.org/list_27_indices.shtml}
}
\seealso{
\code{\link{climdex.pcic-package}}, \code{\link{strptime}}.
}
\keyword{climate}
\keyword{ts}

