% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precipDeviation.R
\docType{data}
\name{precipDeviation}
\alias{precipDeviation}
\title{Worldwide deviation in annual precipitation over the last 21,000 years}
\format{An object of class \code{"raster"}}
\usage{
data(precipDeviation)
}
\description{
Using *PaleoView* version 1.1 (Fordham, *et al.* 2017), 20 100-year climatological
means of annual precipitation were generated over 1,000-year time slices from the
TRaCE21ka experiments implemented using the CCSM 3.0 climate model. We then
calculated deviation through time as the mean of standard deviations between time
slices divided by the time elapsed between time slices. This calculation was
performed using the `deviationThroughTime()` function in the `climateStability`
package.
}
\examples{
data(precipDeviation)
precipStability <- 1/precipDeviation; #calculate stability from deviation

}
\references{
Owens, HL, and RP Guralnick. Submitted, Biodiversity Informatics.
}
\seealso{
\code{\link{deviationThroughTime}} for details on the calculation.
}
\keyword{datasets}
