% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet_api_query.R
\name{get_data_aemet}
\alias{get_data_aemet}
\alias{get_metadata_aemet}
\title{Client tool for AEMET API}
\source{
\url{https://opendata.aemet.es/dist/index.html}
}
\usage{
get_data_aemet(apidest, verbose = FALSE)

get_metadata_aemet(apidest, verbose = FALSE)
}
\arguments{
\item{apidest}{Character string as destination URL. See
\url{https://opendata.aemet.es/dist/index.html}.}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}
}
\value{
A tibble or an empty tibble if no valid results from the API.
}
\description{
Client tool to get data and metadata from AEMET and convert json to tibble.
}
\examples{
# Run this example only if AEMET_API_KEY is detected

url <- "/api/valores/climatologicos/inventarioestaciones/todasestaciones"

if (aemet_detect_api_key()) {
  get_data_aemet(url)
}

# Metadata
if (aemet_detect_api_key()) {
  get_metadata_aemet(url)
}
}
\concept{aemet_api}
