% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cfData-plotMethods.R
\docType{methods}
\name{plot,cfPressure,missing-method}
\alias{plot,cfPressure,missing-method}
\alias{plot.cfPressure}
\title{Plot Mean Sea Level Atmospheric Pressure}
\usage{
\S4method{plot}{cfPressure,missing}(x, y, ggtheme = c("grey", "gray", "bw",
  "linedraw", "light", "minimal", "classic"), scales = c("fixed", "free_x",
  "free_y", "free"), n_col = 1, ...)
}
\arguments{
\item{x}{a cfPressure object.}

\item{y}{missing.}

\item{ggtheme}{character string (partially) matching the
\code{\link[ggplot2]{ggtheme}} to be used for plotting, see
'Theme Selection' below.}

\item{scales}{character string partially matching the \code{scales} argument
in the \code{link[ggplot2]{facet_wrap}} function.}

\item{n_col}{the number of columns of plots (default 1).}

\item{...}{further arguments passed to \code{\link[ggplot2]{theme}}.}
}
\description{
Plot the MSL atmospheric pressure through time.
}
\examples{
\dontrun{
# Retrieve public hourly atmospheric pressure data for the last 30 days at
# Reefton Ews station

# Subtract 30 days from today's date to get the start date
last_month = paste(as.character(Sys.Date() - 30), 0)

reefton_pressure = cf_query(cf_user(), cf_datatype(7, 1, 1), cf_station(),
                            start_date = last_month)

class(reefton_pressure) # cfPressure object

# Plot the atmospheric pressure data using the defaults
plot(reefton_pressure)

# Enlarge the text and add the observations as points
library(ggplot2) # for element_text() and geom_point()
plot(reefton_pressure, ggtheme = "bw", text = element_text(size = 16)) +
  geom_point(size = 3, shape = 1)

# Save the plot as a png to the current working directory
library(ggplot2) # for ggsave()
ggsave("my_pressure_plot.png")
}
}
\seealso{
\code{\link{plot,cfDataList,missing-method}} for general
  information on default plotting of \code{cfData} and \code{cfDataList}
  objects, and the links within. See \code{\link{cf_query}} for creating
  \code{cfPressure} objects.

  Refer to \code{\link[ggplot2]{theme}} for more possible arguments to pass
  to these methods.
}

