% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdate.R
\name{rdate}
\alias{rdate}
\title{Generate random dates}
\usage{
rdate(
  n,
  min = paste0(format(Sys.Date(), "\%Y"), "-01-01"),
  max = paste0(format(Sys.Date(), "\%Y"), "-12-31"),
  ...
)
}
\arguments{
\item{n}{number of observations. If \code{length(n) > 1}, the length
    is taken to be the number required.}

\item{min, max}{lower and upper limits of the distribution. Must be (coercible to) valid dates.}

\item{...}{parameters given to \code{as.Date()} for coercing the values of \code{min} and \code{max}}
}
\description{
This function provides random date generation with a specified range, that defaults to the beginning and end of the current year.
}
\examples{
# generate a million random dates and check the distribution
hist(rdate(1000000), breaks = "months")
}
