% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingness_indicators.R
\name{missingness_indicators}
\alias{missingness_indicators}
\title{Return matrix of missingness indicators for a dataframe or matrix.}
\usage{
missingness_indicators(
  data,
  prefix = "miss_",
  remove_constant = TRUE,
  remove_collinear = TRUE,
  skip_vars = c(),
  verbose = FALSE
)
}
\arguments{
\item{data}{Dataframe or matrix to analyze for missingness.}

\item{prefix}{Name prefix for new indicator columns.}

\item{remove_constant}{Remove any indicators that are all 0 or all 1.}

\item{remove_collinear}{Remove any indicators that are collinear with each
other.}

\item{skip_vars}{Vector of variable names to skip.}

\item{verbose}{If TRUE, print additional information.}
}
\value{
Matrix of missingness indicators
}
\description{
Return matrix of missingness indicators for a dataframe or
  matrix. Removes constant or collinear indicators.
}
\examples{

# Load a test dataset.
data(PimaIndiansDiabetes2, package = "mlbench")

# Check for missing values.
colSums(is.na(PimaIndiansDiabetes2))

# Generate missingness indicators; skip outcome variable.
indicators = missingness_indicators(PimaIndiansDiabetes2,
                                    skip_vars = "diabetes")

# Check missingness.
colSums(indicators)

}
\seealso{
\code{\link{impute_missing_values}}
}
