% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cjbart.R
\name{AMCE}
\alias{AMCE}
\title{Average Marginal Component Effect Estimation with Credible Interval}
\usage{
AMCE(
  data,
  model,
  attribs,
  ref_levels,
  method = "bayes",
  alpha = 0.05,
  cores = 1,
  skip_checks = FALSE
)
}
\arguments{
\item{data}{A data.frame, containing all attributes, covariates, the outcome and id variables to analyze.}

\item{model}{A model object, the result of running \code{cjbart()}}

\item{attribs}{Vector of attribute names for which IMCEs will be predicted}

\item{ref_levels}{Vector of reference levels, used to calculate marginal effects}

\item{method}{Character string, setting the variance estimation method to use. When method is "parametric", a typical combined variance estimate is employed; when \code{method = "bayes"}, the 95\% posterior interval is calculated; and when \code{method = "rubin"}, combination rules are used to combine the variance analogous to in multiple imputation analysis.}

\item{alpha}{Number between 0 and 1 -- the significance level used to compute confidence/posterior intervals. When \code{method = "bayes"}, the posterior interval is calculated by taking the alpha/2 and (1-alpha/2) quantiles of the posterior draws. When \code{method = "rubin"}, the confidence interval equals the IMCE +/- \code{qnorm(alpha/2)}. By default, alpha is 0.05 i.e. generating a 95\% confidence/posterior interval.}

\item{cores}{Number of CPU cores used during prediction phase}

\item{skip_checks}{Boolean, indicating whether to check the structure of the data (default = \code{FALSE}). Only set this to \code{TRUE} if you are confident that the data is structured appropriately}
}
\value{
\code{AMCE} returns an object of type "cjbart", a list object.
\item{amces}{A data.frame containing the average marginal component effects}
\item{alpha}{The significance level used to compute the credible interval}
}
\description{
\code{AMCE} calculates the average marginal component effects from a BART-estimated conjoint model.
}
\details{
The AMCE estimates are the average of all computed OMCEs.
}
\seealso{
\code{\link[=cjbart]{cjbart()}}
}
