% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{services_list_deployments_logs}
\alias{services_list_deployments_logs}
\title{Get the logs for a Service deployment}
\usage{
services_list_deployments_logs(
  id,
  deployment_id,
  start_at = NULL,
  end_at = NULL,
  limit = NULL
)
}
\arguments{
\item{id}{integer required. The ID of the owning Service.}

\item{deployment_id}{integer required. The ID for this deployment.}

\item{start_at}{string optional. Log entries with a lower timestamp will be omitted.}

\item{end_at}{string optional. Log entries with a higher timestamp will be omitted.}

\item{limit}{integer optional. The maximum number of log messages to return. Default of 10000.}
}
\value{
An array containing the following fields:
\item{message}{string, The log message.}
\item{stream}{string, The stream of the log. One of "stdout", "stderr".}
\item{createdAt}{string, The time the log was created.}
\item{source}{string, The source of the log. One of "system", "user".}
}
\description{
Get the logs for a Service deployment
}
