% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccViolin}
\alias{ccViolin}
\title{Draw violin plots}
\usage{
ccViolin(
  value,
  pos,
  violin_width = 0.8,
  col = NA,
  border = "black",
  lwd = par("lwd"),
  lty = par("lty"),
  show_quantile = TRUE,
  pt.col = par("col"),
  cex = par("cex"),
  pch = 16,
  max_density = NULL
)
}
\arguments{
\item{value}{A numeric vector, a matrix or a list. If it is a matrix, boxplots are made by columns.}

\item{pos}{Positions of the boxes.}

\item{violin_width}{Width of violins.}

\item{col}{Filled color of boxes.}

\item{border}{Color for the border as well as the quantile lines.}

\item{lwd}{Line width.}

\item{lty}{Line style}

\item{show_quantile}{Whether to show the quantile lines.}

\item{pt.col}{Point color}

\item{cex}{Point size.}

\item{pch}{Point type.}

\item{max_density}{The maximal density value across several violins. It is used to compare between violins.}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.violin]{circlize::circos.violin} while drawing.
}
\examples{
\donttest{
library(circlizePlus)
cc <- ccPlot(sectors = letters[1:4], xlim = c(0, 10))
track <- ccTrack(ylim = c(0, 1))
cell <- ccCell(sector.index = "a") + ccViolin(value = replicate(runif(10),
n = 10, simplify = FALSE), pos = 1:10 - 0.5, col = 1:10)
track <- track + cell
cc + track
}
}
