% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_circletype.R
\name{remove_circletype}
\alias{remove_circletype}
\title{Remove circletype effect}
\usage{
remove_circletype(id, session = NULL)
}
\arguments{
\item{id}{Id of the text element that has a circletype effect.}

\item{session}{Session of the Shiny app}
}
\value{
Removes circletype effect
}
\description{
Remove circletype effect
}
\examples{
if (interactive()) {
library(shiny)
library(circletyper)

ui <- fluidPage(
  use_circletype(), # load dependencies

  circletype(strong("this is a bold text", id = "teststrong")),

  br(),

  # You can also remove the circletype effect
  actionButton("remove", "remove circletype effect for bold text")
)

server <- function(input, output, session) {


  observeEvent(input$remove, {
    remove_circletype("teststrong", session = session)
  })

}

shinyApp(ui, server)
}
}
