% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineplots.R
\name{add_lineplot}
\alias{add_lineplot}
\title{Add a line plot to a chronicle report}
\usage{
add_lineplot(
  report = "",
  dt,
  x,
  y,
  groups = NULL,
  faceted = NULL,
  scales = NULL,
  smooth_trend = NULL,
  ggtheme = NULL,
  x_axis_label = NULL,
  y_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = NULL,
  lineplot_title = NULL,
  title_level = 2,
  echo = FALSE,
  message = FALSE,
  warning = FALSE,
  fig_width = NULL,
  fig_height = NULL
)
}
\arguments{
\item{report}{Character string containing the text of an Rmarkdown report header (and possibly more chunks). Easily create one with chronicle::new_report(), and if NULL, that will be the default value.}

\item{dt}{data.frame containing the data to plot.}

\item{x}{Value on the x axis.}

\item{y}{Value on the y axis.}

\item{groups}{Name of the column containing the different groups.}

\item{faceted}{If TRUE (default), each group will be plotted separately.}

\item{scales}{From ggplot2::facet_wrap: Should scales be 'fixed', 'free', or free in one dimension ('free_x', 'free_y'). Default is 'fixed'.}

\item{smooth_trend}{If TRUE, adds a ggplot2::geom_smooth() line to the plot. Default is FALSE.}

\item{ggtheme}{ggplot2 theme function to apply. Default is ggplot2::theme_minimal.}

\item{x_axis_label}{Label for the x axis.}

\item{y_axis_label}{Label for the y axis.}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot.}

\item{plot_palette_generator}{Palette from the viridis package, used in case plot_palette is unspecified or insufficient for the number of colors required.}

\item{lineplot_title}{Title of the line plot  section on the report. If NULL, chronicle will try to parse a generic title using make_title()}

\item{title_level}{Level of the section title of this plot (ie, number of # on Rmarkdown syntax.)}

\item{echo}{Whether to display the source code in the output document. Default is FALSE.}

\item{message}{Whether to preserve messages on rendering. Default is FALSE.}

\item{warning}{Whether to preserve warnings on rendering. Default is FALSE.}

\item{fig_width}{Width of the plot (in inches).}

\item{fig_height}{Height of the plot (in inches).}
}
\value{
An R Markdown file as a character string, now containing a chunk for the specified line plot.
}
\description{
Add a line plot to a chronicle report
}
\examples{
html_report <- add_lineplot(report = new_report(),
                            dt = ggplot2::mpg,
                            x = 'hwy',
                            y = 'cty',
                            groups = 'manufacturer',
                            faceted = FALSE)
cat(html_report)
}
