% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directory.R
\name{directory}
\alias{directory}
\alias{directory_load}
\alias{directory_list}
\alias{directory_path}
\alias{directory_set}
\title{The prompt directory}
\usage{
directory_load(dir = directory_path())

directory_list()

directory_path()

directory_set(dir)
}
\arguments{
\item{dir}{Path to a directory of markdown files--see \code{Details} for more.}
}
\value{
\itemize{
\item \code{directory_path()} returns the path to the prompt directory (which is
not created by default unless explicitly requested by the user).
\item \code{directory_set()} return the path to the new prompt directory.
\item \code{directory_list()} returns the file paths of all of the prompts that
currently live in the directory (and provides clickable links to each).
\item \code{directory_load()} returns \code{NULL} invisibly.
}
}
\description{
The chores package's prompt directory is a directory of markdown files that
is automatically registered with the chores package on package load.
\verb{directory_*()} functions allow users to interface with the directory,
making new "chores" available:
\itemize{
\item \code{directory_path()} returns the path to the prompt directory.
\item \code{directory_set()} changes the path to the prompt directory (by setting
the option \code{.chores_dir}).
\item \code{directory_list()} enumerates all of the different prompts that currently
live in the directory (and provides clickable links to each).
\item \code{directory_load()} registers each of the prompts in the prompt
directory with the chores package.
}

\link[=prompt]{Functions prefixed with} \verb{prompt*()} allow users to conveniently create, edit,
and delete the prompts in chores' prompt directory.
}
\section{Format of the prompt directory}{

Prompts are markdown files with the
name \code{chore-interface.md}, where interface is one of
"replace", "prefix" or "suffix".
An example directory might look like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{/
|-- .config/
|   |-- chores/
|       |-- proofread-replace.md
|       |-- summarize-prefix.md
}\if{html}{\out{</div>}}

In that case, chores will register two custom helpers when you call \code{library(chores)}.
One of them is for the "proofread" chore and will replace the selected text with
a proofread version (according to the instructions contained in the markdown
file itself). The other is for the "summarize" chore and will prefix the selected
text with a summarized version (again, according to the markdown file's
instructions). Note:
\itemize{
\item Files without a \code{.md} extension are ignored.
\item Files with a \code{.md} extension must contain only one hyphen in their filename,
and the text following the hyphen must be one of \code{replace}, \code{prefix}, or
\code{suffix}.
}

To load custom prompts every time the package is loaded, place your
prompts in \code{directory_path()}. To change the prompt directory without
loading the package, just set the \code{.chores_dir} option with
\code{options(.chores_dir = some_dir)}. To load a directory of files that's not
the prompt directory, provide a \code{dir} argument to \code{directory_load()}.
}

\examples{
# choose a path for the prompt directory
tmp_dir <- withr::local_tempdir()
directory_set(tmp_dir)

# print out the current prompt directory
directory_path()

# list out prompts currently in the directory
directory_list()

# create a prompt in the prompt directory
prompt_new("boop", "replace")

# view updated list of prompts
directory_list()

# register the prompt with the package
# (this will also happen automatically on reload)
directory_load()

}
\seealso{
The "Custom helpers" vignette, at
\code{vignette("custom", package = "chores")},for more on adding your own
helper prompts, sharing them with others, and using prompts from others.
}
