% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/euclidean.R
\name{neighborhoodEuclidean}
\alias{neighborhoodEuclidean}
\title{Compute Euclidean path pump neighborhoods.}
\usage{
neighborhoodEuclidean(pump.select = NULL, vestry = FALSE,
  case.set = "observed", case.select = "address", latlong = FALSE,
  location = "nominal", brute.force = FALSE, multi.core = FALSE,
  dev.mode = FALSE)
}
\arguments{
\item{pump.select}{Numeric. Vector of numeric pump IDs to define pump neighborhoods (i.e., the "population"). Negative selection possible. \code{NULL} selects all pumps.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry Report. \code{FALSE} uses the 13 in the original map.}

\item{case.set}{Character. "observed" or "expected".}

\item{case.select}{Character. Fatalities: "all" or "address".}

\item{latlong}{Logical. Longitude and latitude coordinates}

\item{location}{Character. "nominal", "anchor" or "orthogonal".}

\item{brute.force}{Logical. For latlong = FALSE. TRUE computes nearest pump for each case. FALSE uses Voronoi cells as shortcut.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. See \code{vignette("Parallelization")} for details.}

\item{dev.mode}{Logical. Development mode uses parallel::parLapply().}
}
\value{
An R list.
}
\description{
Plots star graph from pump to its cases.
}
