% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{to_cpz}
\alias{to_cpz}
\title{Calculates chlorpromazine-equivalent doses}
\usage{
to_cpz(input_data, ap_label, dose_label, route = "oral",
  key = chlorpromazineR::gardner2010, eq_label = "cpz_eq",
  factor_label = "cpz_conv_factor", route_label = NULL,
  q_label = NULL)
}
\arguments{
\item{input_data}{data.frame with antipsychotic name and dose data}

\item{ap_label}{column in x that stores antipsychotic name}

\item{dose_label}{column in x that stores dose}

\item{route}{options include "oral", "sai", "lai" or "mixed"}

\item{key}{source of the conversion factors--defaults to Gardner et al. 2010}

\item{eq_label}{the name of the column to be created, to save the 
calculated CPZ-equivalent dose}

\item{factor_label}{the name of the column to be created to store the
conversion factors}

\item{route_label}{if "mixed" route is specified, provide the column that
stores the route information}

\item{q_label}{if long-acting injectable doses are included, provide the column
that stores the injection frequency (days), or only if the doses have already
been divided, set q_label = 1.}
}
\value{
data.frame with new variables storing conversion factor and 
CPZ-equivalent doses
}
\description{
Given a data.frame containing doses of antipsychotics to_cpz() converts the
doses into the equivalent chlorpromazine (CPZ) doses, using the conversion
factors specified in the key.
}
\details{
The default key is gardner2010 which has data for both oral and long-acting
antipsychotic medications. See help(gardner2010) for the source reference.
}
\examples{
participant_ID <- c("P01", "P02", "P03", "P04")
age <- c(42, 29, 30, 60)
antipsychotic <- c("olanzapine", "olanzapine", "quetiapine", "ziprasidone")
dose <- c(10, 12.5, 300, 60)
example_oral <- data.frame(participant_ID, age, antipsychotic, dose, 
                           stringsAsFactors = FALSE)
to_cpz(example_oral, ap_label = "antipsychotic", dose_label = "dose", 
       route = "oral")
}
\seealso{
Other conversion functions: \code{\link{to_ap}}
}
\concept{conversion functions}
