% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-array.R
\name{chk_array}
\alias{chk_array}
\alias{vld_array}
\title{Check Array}
\usage{
chk_array(x, x_name = NULL)

vld_array(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is a array using

\code{is.array(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_array}: Validate Array
}}

\examples{

# chk_array
chk_array(array(1))
try(chk_array(matrix(1)))

# vld_array
vld_array(1)
vld_array(array(1))
}
\seealso{
Other chk_is: 
\code{\link{chk_atomic}()},
\code{\link{chk_environment}()},
\code{\link{chk_function}()},
\code{\link{chk_list}()},
\code{\link{chk_matrix}()},
\code{\link{chk_numeric}()},
\code{\link{chk_s3_class}()},
\code{\link{chk_s4_class}()},
\code{\link{chk_vector}()},
\code{\link{chk_whole_numeric}()}
}
\concept{chk_is}
