#' Parameter Descriptions for chk Functions
#' @param x The object to check.
#' @param x_name A string of the name of object x or NULL.
#' @param chk A flag specifying whether to check the other parameters.
#'
#' @param chk_fun A chk_ function.
#'
#' @param tolerance A non-negative numeric scalar.
#'
#' @param ext A character vector of the permitted file extensions (without the .).
#'
#' @param y An object to check against.
#'
#' @param value A non-missing scalar of a value.
#' @param range A non-missing sorted vector of length 2 of the lower and upper permitted values.
#'
#' @param regexp A string of a regular expression.
#'
#' @param values A vector of the permitted values.
#'
#' @param class A string specifying the class.
#' @param formals A count of the number of formal arguments.
#'
#' @param incomparables A vector of values that cannot be compared.
#' FALSE means that all values can be compared.
#'
#' @param ... Additional arguments.
#'
#' @keywords internal
#' @name params
NULL
