% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.data.R
\name{prepare.data}
\alias{prepare.data}
\title{prepare.data}
\usage{
prepare.data(
  bam,
  baits,
  fragments,
  replicate.merging.method = "sum",
  include.zeros = c("none", "cis", "all"),
  remove.adjacent = FALSE,
  temp.directory = NULL,
  keep.files = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{bam}{Path to a BAM file}

\item{baits}{Path to a BED file containing the baits}

\item{fragments}{Path to a BED file containing all restriction fragments in the genome}

\item{replicate.merging.method}{Method that should be used for merging replicates, if applicable}

\item{include.zeros}{String specifying what zero counts to include. Options are none (default), cis, and all.}

\item{remove.adjacent}{Logical indicating whether to remove all reads mapping to adjacent restriction fragments.}

\item{temp.directory}{Directory where temporary files should be stored. Defaults to current directory.}

\item{keep.files}{Logical indicating whether to keep temporary files}

\item{verbose}{Logical indicating whether to print progress reports.}
}
\value{
Data table object with columns
	\item{target.id}{String in chrN:start-end format identifying target fragment}
	\item{bait.id}{String in chrN:start-end format identifying bait fragment}
\item{target.chr}{Chromosome of target fragment}
	\item{target.start}{Start coordinate of target fragment (zero-based)}
\item{target.end}{End coordinate of target fragment}
\item{bait.chr}{Chromosome of bait fragment}
	\item{bait.start}{Start coordinate of bait fragment (zero-based)}
\item{bait.end}{End coordinate of bait fragment}
\item{bait.to.bait}{Boolean indicating if the interaction is bait-to-bait (i.e. the fragment listed as target is also a bait)}
	\item{count}{The number of reads linking the two fragments}
	\item{bait.trans.count}{The number of reads linking the bait to fragments in trans (a measure of "interactibility")}
	\item{target.trans.count}{The number of reads linking the target to fragments in trans (a measure of "interactibility")}
	\item{distance}{Distance between the midpoints of the bait and target fragments (basepairs). NA for trans interactions}
}
\description{
Prepare data for running interaction calling. Takes a BAM file and baits and restriction fragments as input, and returns a data table with data ready for analysis.
}
\examples{
\donttest{
if( bedtools.installed() ) {
  bam <- system.file('extdata', 'Bre80_2q35.bam', package = 'chicane');
  baits <- system.file('extdata', '2q35.bed', package = 'chicane');
  fragments <- system.file('extdata', 'GRCh38_HindIII_chr2.bed.gz', package = 'chicane');
  input.data <- prepare.data(
	bam = bam, 
	baits = baits, 
	fragments = fragments
	);
 }
}

}
