% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vst02.R
\docType{data}
\name{vst02_2_main}
\alias{vst02_2_main}
\alias{vst02_2}
\title{\code{VST02} Vital Sign Abnormalities Table.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
vst02_2_main(
  adam_db,
  arm_var = "ACTARM",
  lbl_overall = NULL,
  exclude_base_abn = TRUE,
  ...
)

vst02_2
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{exclude_base_abn}{(\code{flag}) whether baseline abnormality should be excluded.}

\item{...}{not used.}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
Vital Sign Parameters outside Normal Limits Among Patients without Abnormality at Baseline.
}
\details{
\itemize{
\item Only count LOW or HIGH values.
\item Results of "LOW LOW" are treated as the same as "LOW", and "HIGH HIGH" the same as "HIGH".
\item Does not include a total column by default.
\item Does not remove zero-count rows unless overridden with \code{prune_0 = TRUE}.
}
}
\section{Functions}{
\itemize{
\item \code{vst02_2_main()}: Main TLG function

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{advs} table with the \code{"PARAM"}, \code{"ANRIND"} and \code{"BNRIND"} columns.
}
}
\examples{
run(vst02_2, syn_data)
}
\keyword{datasets}
