% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names.R
\name{check_names}
\alias{check_names}
\title{Check Names}
\usage{
check_names(x, names = character(0), exclusive = FALSE,
  order = FALSE, unique = FALSE, complete = TRUE,
  x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{names}{A character vector of the names.}

\item{exclusive}{A flag indicating whether other names are not permitted.}

\item{order}{A flag indicating whether the object names have to occur in the same order as names.}

\item{unique}{A flag indicating whether all the object names have to be unique.}

\item{complete}{A flag indicating whether all the possible names have to be represented.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or 
immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks the names of an object as returned by the `names()` function. 
The function can check the order of the names and whether other names are permitted.
}
\examples{
vec <- c(x = 1, y = 2, z = 0)
check_names(vec, c("y", "x"), error = FALSE)
check_names(vec, c("y", "x"), exclusive = TRUE, error = FALSE)
check_names(vec, c("y", "x"), order = TRUE, error = FALSE)
check_names(vec, c("a"), error = FALSE)
}
\seealso{
\code{\link{check_named}}
}
