\name{PELT.mean.norm}
\alias{PELT.mean.norm}
\title{
Multiple Changes in Mean using PELT pruned method - Normal Data
}
\description{
Calculates the optimal positioning and number of changepoints for Normal data using PELT pruned method.
}
\usage{
PELT.mean.norm(data, pen=0, nprune=FALSE)
}
\arguments{
  \item{data}{
	A vector containing the data within which you wish to find changepoints.
}
  \item{pen}{
	Numeric value of the linear penalty function.  This value is used in the decision for each individual changepoint so that in total the penalty is k*pen where k is the optimal number of changepoints detected.
}
  \item{nprune}{
	Logical.  If nprune=FALSE, the locations of the changepoints are returned.  If nprune=TRUE then the number of points kept at each stage of pruning is returned instead.
}
}
\details{
	This function is used to find a multiple changes in mean for data that is assumed to be normally distributed.  The value returned is the result of testing H0:existing number of changepoints against H1: one extra changepoint using the log of the likelihood ratio statistic coupled with the penalty supplied.  The PELT method keeps track of the optimal number and location of changepoints as it passes through the data.
}
\value{
	If nprune=FALSE then a vector of the changepoint locations is returned:
	\item{cpt}{Vector containing the changepoint locations for the penalty supplied.  This always ends with n.}
	If nprune=TRUE then a vector of the number of points kept during pruning at each iteration is returned:
	\item{nprune}{Vector containing the number of points kept at each stage of pruning.}
}
\references{
Change in Normal mean: Hinkley, D. V. (1970) Inference About the Change-Point in a Sequence of Random Variables, \emph{Biometrika} \bold{57}, 1--17

PELT Algorithm: Killick, R. and Fearnhead, P. and Eckley, I.A. (2011) An exact linear time search algorithm for multiple changepoint detection, \emph{Submitted}

}
\author{
Rebecca Killick
}


\seealso{
\code{\link{PELT.var.norm}},\code{\link{PELT.meanvar.norm}},\code{\link{cpt.mean}},\code{\link{binseg.mean.norm}},\code{\link{multiple.mean.norm}},\code{\link{single.mean.norm}},\code{\link{segneigh.mean.norm}}
}
\examples{
# Example of multiple changes in mean at 50,100,150 in simulated normal data
set.seed(1)
x=c(rnorm(50,0,1),rnorm(50,5,1),rnorm(50,10,1),rnorm(50,3,1))
PELT.mean.norm(x,pen=2*log(200)) # returns c(50,100,150,200)
PELT.mean.norm(x,pen=2*log(200),nprune=TRUE) # returns vector showing how many points are kept during pruing at each iteration of the method

# Example no change in mean
set.seed(10)
x=rnorm(200,0,1)
PELT.mean.norm(x,pen=2*log(200)) # returns 200 to show no change in mean has been found
PELT.mean.norm(x,pen=2*log(200),nprune=TRUE) # notice how the number of points kept it steadily increasing compare to the previous example where it almost resets when a true change has been found
}

\keyword{methods}
\keyword{univar}
\keyword{models}
\keyword{ts}
