% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espn_metrics_wp.R
\name{espn_metrics}
\alias{espn_metrics}
\alias{espn_metrics_wp}
\title{\strong{ESPN Metrics}}
\usage{
espn_metrics_wp(game_id)
}
\arguments{
\item{game_id}{(\emph{Integer} required): Game ID filter for querying a single game
Can be found using the \code{\link[=cfbd_game_info]{cfbd_game_info()}} function}
}
\value{
\code{\link[=espn_metrics_wp]{espn_metrics_wp()}} - A data frame with 5 variables:
\describe{
\item{\code{game_id}: character.}{Referencing game ID (should be same as \code{game_id} from other functions).}
\item{\code{play_id}: character.}{Referencing play ID.}
\item{\code{seconds_left}: integer.}{Seconds left in the game.}
\item{\code{home_win_percentage}: double.}{The probability of the home team winning the game.}
\item{\code{away_win_percentage}: double.}{The probability of the away team winning the game (calculated as 1 - \code{home_win_percentage} - \code{tie_percentage}).}
\item{\code{tie_percentage}: double.}{The probability of the game ending the final period in a tie.}
}
}
\description{
\strong{ESPN Metrics}

Get win probability chart data from ESPN
Graciously contributed by MrCaseB:
}
\examples{
\donttest{
  try(espn_metrics_wp(game_id = 401114164))
}

}
\keyword{Chart}
\keyword{Data}
\keyword{Probability}
\keyword{Win}
