% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_deconv.R
\name{tune_deconv}
\alias{tune_deconv}
\title{Tune deconvolution parameters}
\usage{
tune_deconv(
  mk,
  test,
  samples,
  grid,
  output = "output",
  metric = "RMSE",
  method = "top",
  verbose = TRUE,
  cores = 1,
  ...
)
}
\arguments{
\item{mk}{cellMarkers class object}

\item{test}{matrix of bulk RNA-Seq to be deconvoluted. Passed to
\code{\link[=deconvolute]{deconvolute()}}.}

\item{samples}{matrix of cell amounts with subclasses in columns and samples
in rows. Note that if this has been generated by \code{\link[=simulate_bulk]{simulate_bulk()}}, using a
value of \code{times} other than 1, then it is important that this is adjusted
for here.}

\item{grid}{Named list of vectors for the tuning grid similar to
\code{\link[=expand.grid]{expand.grid()}}. Names represent the parameter to be tuned which must be an
argument in either \code{\link[=updateMarkers]{updateMarkers()}} or \code{\link[=deconvolute]{deconvolute()}}. The elements of
each vector are the values to be tuned for each parameter.}

\item{output}{Character value, either \code{"output"} or \code{"percent"} specifying
which output from the subclass results element resulting from a call to
\code{\link[=deconvolute]{deconvolute()}}. This deconvolution result is compared against the actual
sample cell numbers in \code{samples}, using \code{\link[=metric_set]{metric_set()}}.}

\item{metric}{Specifies tuning metric to choose optimal tune: either
"RMSE", "Rsq" or "pearson".}

\item{method}{Either "top" or "overall". Determines how best parameter values
are chosen. With "top" the single top configuration is chosen. With
"overall", the average effect of varying each parameter is calculated using
the mean R-squared across all variations of other parameters. This can give
a more stable choice of final tuning.}

\item{verbose}{Logical whether to show progress.}

\item{cores}{Number of cores for parallelisation via \code{\link[parallel:mclapply]{parallel::mclapply()}}.
Parallelisation is not available on windows.}

\item{...}{Optional arguments passed to \code{\link[=deconvolute]{deconvolute()}} to control fixed
settings.}
}
\value{
Dataframe with class \code{'tune_deconv'} whose columns include: the
parameters being tuned via \code{grid}, cell subclass and R squared.
}
\description{
Performs an exhaustive grid search over a tuning grid of cell marker and
deconvolution parameters for either \code{\link[=updateMarkers]{updateMarkers()}} (e.g. \code{expfilter} or
\code{nsubclass}) or \code{\link[=deconvolute]{deconvolute()}} (e.g. \code{comp_amount}).
}
\details{
Tuning plots on the resulting object can be visualised using \code{\link[=plot_tune]{plot_tune()}}.
If \code{best_tune} is set to "overall", this corresponds to setting
\code{subclass = NULL} in \code{\link[=plot_tune]{plot_tune()}}.

Once the results output has been generated, arguments such as \code{metric} or
\code{method} can be changed to see different best tunes using \code{summary()} (see
\code{\link[=summary.tune_deconv]{summary.tune_deconv()}}).

\code{test} and \code{samples} matrices can be generated by \code{\link[=simulate_bulk]{simulate_bulk()}} and
\code{\link[=generate_samples]{generate_samples()}} based on the original scRNA-Seq count dataset.
}
\seealso{
\code{\link[=plot_tune]{plot_tune()}} \code{\link[=summary.tune_deconv]{summary.tune_deconv()}}
}
