% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profiles.R
\name{cbc_restrict}
\alias{cbc_restrict}
\title{Obtain a restricted set of profiles}
\usage{
cbc_restrict(profiles, ...)
}
\arguments{
\item{profiles}{A data frame in which each row is a possible profile.
This can be generated using the \code{cbc_profiles()} function.}

\item{...}{Any number of restricted pairs of attribute levels, defined as
pairs of logical expressions separated by commas. For example, the
restriction \code{type == 'Fuji' & freshness == 'Poor'} will eliminate profiles
such that \code{"Fuji"} type apples will never be shown with \code{"Poor"} freshness.}
}
\value{
A restricted set of profiles as a data frame.
}
\description{
This function returns a restricted set of profiles as a data frame.
}
\examples{
library(cbcTools)

# Generate all profiles for a simple conjoint experiment about apples
profiles <- cbc_profiles(
  price     = c(1, 1.5, 2, 2.5, 3, 3.5, 4, 4.5, 5),
  type      = c("Fuji", "Gala", "Honeycrisp"),
  freshness = c('Poor', 'Average', 'Excellent')
)

# Obtain a restricted subset of profiles based on pairs of logical
# expressions. The example below contains the following restrictions:

# - `"Gala"` apples will not be shown with the prices `1.5`, `2.5`, & `3.5`.
# - `"Honeycrisp"` apples will not be shown with prices less than `2`.
# - `"Honeycrisp"` apples will not be shown with the `"Poor"` freshness.
# - `"Fuji"` apples will not be shown with the `"Excellent"` freshness.

profiles_restricted <- cbc_restrict(
    profiles,
    type == "Gala" & price \%in\% c(1.5, 2.5, 3.5),
    type == "Honeycrisp" & price > 2,
    type == "Honeycrisp" & freshness == "Poor",
    type == "Fuji" & freshness == "Excellent"
)
}
