% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_models.R
\docType{class}
\name{causalEffect-class}
\alias{causalEffect-class}
\title{causalEffect class}
\description{
causalEffect class
}
\details{
The \code{variance.components} slot is a list with slots
\itemize{
\item \code{E_Y1}: The mean if the target population had all been treated.
\item \code{E_Y0}: The mean if the target population had all received control
\item \code{E_Y1_X}: The predicted conditional mean if the target population had all been treated.
\item \code{E_Y0_X}: The predicted conditional mean if the target population had all received control.
}
Note that for "ATT" and "ATC" estimands, \code{E_Y1_X} or \code{E_Y0_X} will be NA, respectively.

Meanwhile, the \code{options} slot is a list with slots
\itemize{
\item \code{hajek}: Were weights normalized to sum to 1 (TRUE/FALSE)
\item \code{doubly.robust}: Was an augmented estimator used? (TRUE/FALSE)
\item \code{matched}: Wass barycentric projection estimator used? (TRUE/FALSE)
\item \code{split.model} Was the outcome model calculated separately in each
treatment group? (TRUE/FALSE)
\item \code{balance.covariates}: The covariates selected for balance or in the outcome model in slot \code{data}
\item \code{treatment.indicator}: The column that is the treatment indicator in slot \code{data}
\item \code{outcome}: The columns that is the outcome in  slot \code{data}
\item \code{addl.args}: Any additional arguments passed in the dots (\code{...})
of \link[=estimate_effect]{estimate_effect()}.
}
}
\section{Slots}{

\describe{
\item{\code{estimate}}{The estimated treatment effect.}

\item{\code{data}}{The original data as a \code{data.frame}.}

\item{\code{model}}{The function used as the outcome model.}

\item{\code{formula}}{The formula for the outcome model.}

\item{\code{weights}}{The weights as an object of class \link[=causalWeights-class]{causalWeights}}

\item{\code{estimand}}{A character denoting the estimand targeted by the weights. One of "ATT","ATC", or "ATE".}

\item{\code{variance.components}}{Objects for the asymptotic variance calculation designed so expensive models
don't have to be re-fit.}

\item{\code{options}}{A list with the arguments from the \link[=estimate_effect]{estimate_effect} function. See details.}

\item{\code{call}}{The call from the \link[=estimate_effect]{estimate_effect()} function.}
}}

