% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_cdcorr.R
\name{cb.align.vm_trim}
\alias{cb.align.vm_trim}
\title{Vector Matching}
\usage{
cb.align.vm_trim(Ts, Xs, retain.ratio = 0.05, ddx = FALSE)
}
\arguments{
\item{Ts}{\code{[n]} the labels of the samples, with \code{K < n} levels, as a factor variable.}

\item{Xs}{\code{[n, r]} the \code{r} covariates/confounding variables, for each of the \code{n} samples.}

\item{retain.ratio}{If the number of samples retained is less than \code{retain.ratio*n}, throws a warning. Defaults to \code{0.05}.}

\item{ddx}{whether to show additional diagnosis messages. Defaults to \code{FALSE}. Can help with debugging if unexpected results are obtained.}
}
\value{
a \code{[m]} vector containing the indices of samples retained after vector matching.
}
\description{
A function for implementing the vector matching procedure, a pre-processing step for
causal conditional distance correlation. Uses propensity scores to strategically include/exclude
samples from subsequent inference, based on whether (or not) there are samples with similar propensity scores
across all treatment levels (conceptually, a k-way "propensity trimming"). 
It is imperative that this function is used in conjunction with domain expertise to ensure that the covariates are not colliders, 
and that the system satisfies the strong ignorability condiiton to derive causal conclusions.
}
\section{Details}{

For more details see the help vignette:
\code{vignette("causal_balancing", package = "causalBatch")}
}

\examples{
library(causalBatch)
sim <- cb.sims.sim_linear(a=-1, n=100, err=1/8, unbalancedness=3)
cb.align.vm_trim(sim$Ts, sim$Xs)

}
\references{
Michael J. Lopez, et al. "Estimation of Causal Effects with Multiple Treatments" Statistical Science (2017). 
ran
}
\author{
Eric W. Bridgeford
}
