% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{plot.ancestralCauchy}
\alias{plot.ancestralCauchy}
\title{Plot for class \code{ancestralCauchy}}
\usage{
\method{plot}{ancestralCauchy}(x, node, n_col, intervals = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{ancestralCauchy}, result of function
\code{\link{ancestral}} or \code{\link{increment}}.}

\item{node}{the vector of nodes where to plot the ancestral reconstruction.
Can be missing, in which case all the nodes reconstructed in the \code{ancestralCauchy}
object are plotted.}

\item{n_col}{the number of columns on which to display the plot.
Can be missing, in which case a default number is used.}

\item{intervals}{a list of HDI intervals produced by function \code{\link{hdi.ancestralCauchy}}.
If the HDI of a plotted node is in the list, then it is plotted by the function.}

\item{...}{further arguments to be passed to \code{\link{plot}}.}
}
\value{
None.
}
\description{
This function takes an object of class \code{ancestralCauchy}, result of function
\code{\link{ancestral}} or \code{\link{increment}}, and plots the reconstructed states for given nodes.
}
\examples{
set.seed(1289)
# Simulate tree and data
phy <- ape::rphylo(10, 0.1, 0)
dat <- rTraitCauchy(n = 1, phy = phy, model = "cauchy",
                    parameters = list(root.value = 10, disp = 0.1))
# Fit the data
fit <- fitCauchy(phy, dat, model = "cauchy", method = "reml")
# Reconstruct the ancestral values
inc <- increment(fit, node = c(3, 8), values = seq(-3, 3, 0.01))
plot(inc, type = "l")
anc <- ancestral(fit, node = c(12, 17), n_values = 1000)
plot(anc, type = "l")

}
\seealso{
\code{\link{plot_asr}}, \code{\link{ancestral}}, \code{\link{increment}}, \code{\link{fitCauchy}}
}
