% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_level_1.R
\name{create_level_1}
\alias{create_level_1}
\title{Level 1 CAT decision tree generator}
\usage{
create_level_1(bank, crit, dens_vec, C, nres, prob_array)
}
\arguments{
\item{bank}{matrix of the item bank. Rows represent items, and columns
represent parameters. If the model is \code{"GRM"}, the first column
represents the \code{alpha} parameters and the next columns represent the
\code{beta} parameters. If the model is \code{"NRM"}, odd columns represent
the \code{alpha} parameters and even columns represent \code{beta}
parameters}

\item{crit}{item selection criterion. Options: "MEPV" for Minimum
Expected Posterior Variance and "MFI" for Maximum Fisher Information}

\item{dens_vec}{vector of the a priori density function values of the
evaluated ability levels}

\item{C}{vector of item capacities}

\item{nres}{vector of number of possible responses for every item}

\item{prob_array}{3-D array of probability responses. Dim 1 represent items,
dim 2 represent evaluated ability levels and dim 3 represent possible
responses}
}
\value{
A list of lists. Each of these lists represent a node of the first
level of the decision tree
}
\description{
Generates a list of nodes lists for the first level of the CAT decision tree
}
\author{
Javier Rodríguez-Cuadrado
}
